/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.TagsMCA;
import forge.net.mca.block.TombstoneBlock;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.ActivityMCA;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.entity.ai.relationship.EntityRelationship;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.RelationshipType;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.entity.interaction.gifts.GiftSaturation;
import forge.net.mca.server.world.data.GraveyardManager;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.compat.OptionalCompat;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Relationship<T extends MobEntity>
implements EntityRelationship {
    public static final Predicate IS_MARRIED = (villager, player) -> villager.getRelationships().isMarriedTo(player);
    public static final Predicate IS_ENGAGED = (villager, player) -> villager.getRelationships().isEngagedWith(player);
    public static final Predicate IS_PROMISED = (villager, player) -> villager.getRelationships().isPromisedTo(player);
    public static final Predicate IS_RELATIVE = (villager, player) -> villager.getRelationships().getFamilyEntry().isRelative(player);
    public static final Predicate IS_FAMILY = IS_MARRIED.or(IS_RELATIVE);
    public static final Predicate IS_PARENT = (villager, player) -> villager.getRelationships().getFamilyEntry().isParent(player);
    public static final Predicate IS_ORPHAN = (villager, player) -> villager.getRelationships().getFamilyEntry().getParents().allMatch(FamilyTreeNode::isDeceased);
    protected final T entity;
    private final GiftSaturation giftSaturation = new GiftSaturation();

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(new CParameter[0]);
    }

    public Relationship(T entity) {
        this.entity = entity;
    }

    @Override
    public Gender getGender() {
        return ((VillagerLike)this.entity).getGenetics().getGender();
    }

    @Override
    public ServerWorld getWorld() {
        return (ServerWorld)((MobEntity)this.entity).field_70170_p;
    }

    @Override
    public UUID getUUID() {
        return this.entity.func_110124_au();
    }

    @Override
    @NotNull
    public FamilyTreeNode getFamilyEntry() {
        return this.getFamilyTree().getOrCreate((Entity)this.entity);
    }

    public void onDeath(DamageSource cause) {
        boolean beRemembered = this.getFamilyEntry().willBeRemembered();
        boolean beLoved = ((VillagerLike)this.entity).getVillagerBrain().getMemories().values().stream().anyMatch(m -> m.getHearts() > Config.getInstance().heartsRequiredToAutoSpawnGravestone);
        if (beRemembered || beLoved || !((VillagerLike)this.entity).isHostile()) {
            this.getFamilyEntry().setDeceased(true);
            OptionalCompat.ifPresentOrElse(GraveyardManager.get((ServerWorld)((MobEntity)this.entity).field_70170_p).findNearest(this.entity.func_233580_cy_(), GraveyardManager.TombstoneState.EMPTY, 10), pos -> {
                TileEntity be;
                if (((MobEntity)this.entity).field_70170_p.func_180495_p(pos).func_235714_a_(TagsMCA.Blocks.TOMBSTONES) && (be = ((MobEntity)this.entity).field_70170_p.func_175625_s(pos)) instanceof TombstoneBlock.Data) {
                    this.onTragedy(cause, (BlockPos)pos);
                    ((TombstoneBlock.Data)be).setEntity((Entity)this.entity);
                }
                this.onTragedy(cause, null);
            }, () -> this.onTragedy(cause, null));
        } else {
            this.onTragedy(cause, null);
        }
        if (!beRemembered) {
            this.getFamilyEntry().streamParents().forEach(uuid -> this.getFamilyTree().remove((UUID)uuid));
            this.getFamilyTree().remove(this.entity.func_110124_au());
        }
    }

    public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite) {
        if (!((VillagerLike)this.entity).isHostile()) {
            WorldUtils.getCloseEntities(((MobEntity)this.entity).field_70170_p, this.entity, 32.0, VillagerEntityMCA.class).forEach(villager -> villager.getRelationships().onTragedy(cause, burialSite, RelationshipType.STRANGER, (Entity)this.entity));
        }
        this.onTragedy(cause, burialSite, RelationshipType.SELF, (Entity)this.entity);
    }

    @Override
    public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite, RelationshipType type, Entity with) {
        if (!cause.func_76357_e()) {
            int moodAffect = 5 * type.getProximityAmplifier();
            ((MobEntity)this.entity).field_70170_p.func_72960_a(this.entity, (byte)17);
            ((VillagerLike)this.entity).getVillagerBrain().modifyMoodValue(-moodAffect);
            if (cause.func_76346_g() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)cause.func_76346_g();
                ((VillagerLike)this.entity).getVillagerBrain().getMemoriesForPlayer(player).modHearts(-20);
            }
        }
        if (burialSite != null && type != RelationshipType.STRANGER) {
            this.entity.func_213375_cj().func_218202_a((Activity)ActivityMCA.GRIEVE.get());
            this.entity.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(burialSite, 1.0f, 1));
            this.entity.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(burialSite));
        }
        EntityRelationship.super.onTragedy(cause, burialSite, type, with);
    }

    public GiftSaturation getGiftSaturation() {
        return this.giftSaturation;
    }

    public void readFromNbt(CompoundNBT nbt) {
        this.giftSaturation.readFromNbt(nbt.func_150295_c("giftSaturationQueue", 8));
    }

    public void writeToNbt(CompoundNBT nbt) {
        nbt.func_218657_a("giftSaturationQueue", (INBT)this.giftSaturation.toNbt());
    }

    public static interface Predicate
    extends BiPredicate<CompassionateEntity<?>, Entity> {
        @Override
        public boolean test(CompassionateEntity<?> var1, UUID var2);

        @Override
        default public boolean test(CompassionateEntity<?> villager, Entity partner) {
            return partner != null && this.test(villager, partner.func_110124_au());
        }

        default public Predicate or(Predicate b) {
            return (villager, partner) -> this.test(villager, partner) || b.test(villager, partner);
        }

        default public Predicate negate() {
            return (villager, partner) -> !this.test(villager, partner);
        }

        default public BiPredicate<VillagerLike<?>, ServerPlayerEntity> asConstraint() {
            return (villager, player) -> villager instanceof CompassionateEntity && this.test((CompassionateEntity)((Object)villager), (Entity)player);
        }
    }
}

