/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.GraveyardManager;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.compat.OptionalCompat;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.server.ServerWorld;

public class Residency {
    private static final CDataParameter<Integer> BUILDING = CParameter.create("buildings", -1);
    private static final CDataParameter<BlockPos> HANGOUT = CParameter.create("hangoutPos", BlockPos.field_177992_a);
    private final VillagerEntityMCA entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(BUILDING, HANGOUT);
    }

    public Residency(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public BlockPos getWorkplace() {
        return this.entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220942_c).map(GlobalPos::func_218180_b).orElse(BlockPos.field_177992_a);
    }

    public void setWorkplace(PlayerEntity player) {
        this.entity.sendChatMessage(player, "interaction.setworkplace.success", new Object[0]);
        this.entity.func_213375_cj().func_218189_b(MemoryModuleType.field_220942_c);
        this.entity.func_213375_cj().func_218189_b(MemoryModuleType.field_234101_d_);
    }

    public BlockPos getHangout() {
        return (BlockPos)this.entity.getTrackedValue(HANGOUT);
    }

    public void setHangout(PlayerEntity player) {
        this.entity.sendChatMessage(player, "interaction.sethangout.success", new Object[0]);
        this.entity.setTrackedValue(HANGOUT, player.func_233580_cy_());
    }

    public void setBuildingId(int id) {
        this.entity.setTrackedValue(BUILDING, id);
    }

    public Optional<Village> getHomeVillage() {
        VillageManager manager = VillageManager.get((ServerWorld)this.entity.field_70170_p);
        return manager.getOrEmpty(manager.mapBuildingToVillage((Integer)this.entity.getTrackedValue(BUILDING)));
    }

    public Optional<Building> getHomeBuilding() {
        Optional<Building> building = this.getHomeVillage().flatMap(v -> v.getBuilding((Integer)this.entity.getTrackedValue(BUILDING)));
        if (!building.isPresent()) {
            this.setHomeLess();
        }
        return building;
    }

    public void leaveHome() {
        VillageManager manager = VillageManager.get((ServerWorld)this.entity.field_70170_p);
        Optional<Village> village = this.getHomeVillage();
        village.ifPresent(v -> {
            Optional<Building> building = v.getBuilding((Integer)this.entity.getTrackedValue(BUILDING));
            if (building.isPresent()) {
                building.get().getResidents().remove(this.entity.func_110124_au());
                manager.markDirty();
            }
            v.cleanReputation();
            v.markDirty((ServerWorld)this.entity.field_70170_p);
        });
    }

    public Optional<GlobalPos> getHome() {
        return this.getHomeBuilding().map(building -> GlobalPos.func_239648_a_((RegistryKey)this.entity.field_70170_p.func_234923_W_(), (BlockPos)building.getCenter()));
    }

    public void tick() {
        if (!this.entity.requiresHome()) {
            return;
        }
        if (this.entity.field_70173_aa % 600 == 0 && this.entity.doesProfessionRequireHome()) {
            if (!this.getHomeVillage().filter(v -> !v.isAutoScan()).isPresent()) {
                this.reportBuildings();
            }
            if ((Integer)this.entity.getTrackedValue(BUILDING) == -1) {
                Village.findNearest((Entity)this.entity).ifPresent(this::seekNewHome);
            }
        }
        if (this.entity.field_70173_aa % 1200 == 0) {
            OptionalCompat.ifPresentOrElse(this.getHomeVillage(), village -> {
                Optional<Building> building = village.getBuilding((Integer)this.entity.getTrackedValue(BUILDING));
                if (!building.filter(b -> b.hasResident(this.entity.func_110124_au()) && !b.isCrowded()).isPresent()) {
                    if (building.isPresent()) {
                        this.setHomeLess();
                    }
                } else {
                    Optional globalPos = this.entity.getMCABrain().func_218207_c(MemoryModuleType.field_220941_b);
                    if (globalPos.isPresent() && !building.get().containsPos((Vector3i)((GlobalPos)globalPos.get()).func_218180_b())) {
                        this.setHomeLess();
                        return;
                    }
                    int mood = village.popMood((ServerWorld)this.entity.field_70170_p);
                    if (mood != 0) {
                        this.entity.getVillagerBrain().modifyMoodValue(mood);
                    }
                    this.entity.field_70170_p.func_217369_A().forEach(player -> {
                        int rep = village.popHearts((PlayerEntity)player);
                        if (rep != 0) {
                            this.entity.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player).modHearts(rep);
                        }
                    });
                    this.entity.field_70170_p.func_217369_A().forEach(player -> {
                        int hearts = this.entity.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player).getHearts();
                        village.setReputation((PlayerEntity)player, this.entity, hearts);
                    });
                }
            }, this::setHomeLess);
        }
    }

    private void setHomeLess() {
        Optional<Village> village = this.getHomeVillage();
        village.ifPresent(buildings -> buildings.removeResident(this.entity));
        this.setBuildingId(-1);
        this.entity.getMCABrain().func_218189_b(MemoryModuleType.field_220941_b);
    }

    private void setBuilding(Building b) {
        List<BlockPos> group = b.getBlocksOfGroup(new ResourceLocation("minecraft:beds"));
        if (group.size() > 0) {
            this.setBuilding(b, group.get(b.getResidents().size() % group.size()));
        } else {
            this.setBuilding(b, b.getCenter());
        }
    }

    private void setBuilding(Building b, BlockPos p) {
        this.setBuildingId(b.getId());
        this.entity.getMCABrain().func_218205_a(MemoryModuleType.field_220941_b, (Object)GlobalPos.func_239648_a_((RegistryKey)this.entity.field_70170_p.func_234923_W_(), (BlockPos)p));
    }

    private void reportBuildings() {
        VillageManager manager = VillageManager.get((ServerWorld)this.entity.field_70170_p);
        Stream stream = ((ServerWorld)this.entity.field_70170_p).func_217443_B().func_225399_a(PointOfInterestType.field_221053_a, p -> !manager.cache.contains(p), this.entity.func_233580_cy_(), 48, PointOfInterestManager.Status.ANY);
        stream.forEach(manager::reportBuilding);
        GraveyardManager.get((ServerWorld)this.entity.field_70170_p).reportToVillageManager((Entity)this.entity);
    }

    private boolean seekNewHome(Village village) {
        List buildings = village.getBuildings().values().stream().filter(Building::hasFreeSpace).collect(Collectors.toList());
        if (!buildings.isEmpty()) {
            Building b = (Building)buildings.get(this.entity.func_70681_au().nextInt(buildings.size()));
            this.setBuilding(b);
            village.addResident(this.entity, b.getId());
            return true;
        }
        return false;
    }

    public void setHome(PlayerEntity player) {
        VillageManager manager = VillageManager.get((ServerWorld)player.field_70170_p);
        manager.processBuilding(player.func_233580_cy_(), true, false);
        OptionalCompat.ifPresentOrElse(manager.findNearestVillage((Entity)player), village -> OptionalCompat.ifPresentOrElse(village.getBuildingAt((Vector3i)player.func_233580_cy_()), building -> {
            if (!this.entity.doesProfessionRequireHome() || this.entity.getDespawnDelay() > 0) {
                this.entity.sendChatMessage(player, "interaction.sethome.temporary", new Object[0]);
            } else if (building.hasFreeSpace()) {
                this.entity.sendChatMessage(player, "interaction.sethome.success", new Object[0]);
                this.setHomeLess();
                this.setBuilding((Building)building, player.func_233580_cy_());
                village.addResident(this.entity, building.getId());
            } else if (building.getBuildingType().noBeds()) {
                this.entity.sendChatMessage(player, "interaction.sethome.bedfail." + building.getBuildingType().name(), new Object[0]);
            } else if (building.getBedCount() == 0) {
                this.entity.sendChatMessage(player, "interaction.sethome.nobeds", new Object[0]);
            } else {
                this.entity.sendChatMessage(player, "interaction.sethome.bedfail", new Object[0]);
            }
        }, () -> this.entity.sendChatMessage(player, "interaction.sethome.fail", new Object[0])), () -> this.entity.sendChatMessage(player, "interaction.sethome.fail", new Object[0]));
    }

    public void goHome(PlayerEntity player) {
        OptionalCompat.ifPresentOrElse(this.getHome().filter(p -> p.func_239646_a_() == this.entity.field_70170_p.func_234923_W_()), home -> {
            this.entity.moveTowards(home.func_218180_b());
            this.entity.sendChatMessage(player, "interaction.gohome.success", new Object[0]);
        }, () -> this.entity.sendChatMessage(player, "interaction.gohome.fail.nohome", new Object[0]));
    }
}

