/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Traits {
    private static final CDataParameter<CompoundNBT> TRAITS = CParameter.create("traits", new CompoundNBT());
    private Random random;
    private final VillagerLike<?> entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(TRAITS);
    }

    public Traits(VillagerLike<?> entity) {
        this.entity = entity;
        this.random = new Random(entity.asEntity().field_70170_p.field_73012_v.nextLong());
    }

    public Set<Trait> getTraits() {
        return ((CompoundNBT)this.entity.getTrackedValue(TRAITS)).func_150296_c().stream().map(Trait::valueOf).collect(Collectors.toSet());
    }

    public Set<Trait> getInheritedTraits() {
        return this.getTraits().stream().filter(t -> this.random.nextFloat() < ((Trait)t).inherit * Config.getInstance().traitInheritChance).collect(Collectors.toSet());
    }

    public boolean hasTrait(VillagerLike<?> target, Trait trait) {
        return ((CompoundNBT)target.getTrackedValue(TRAITS)).func_74764_b(trait.name());
    }

    public boolean hasTrait(Trait trait) {
        return this.hasTrait(this.entity, trait);
    }

    public boolean hasTrait(String trait) {
        return this.hasTrait(this.entity, Trait.valueOf(trait.toUpperCase(Locale.ROOT)));
    }

    public boolean eitherHaveTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) || this.hasTrait(other, trait);
    }

    public boolean hasSameTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) && this.hasTrait(other, trait);
    }

    public void addTrait(Trait trait) {
        CompoundNBT traits = ((CompoundNBT)this.entity.getTrackedValue(TRAITS)).func_74737_b();
        traits.func_74757_a(trait.name(), true);
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void removeTrait(Trait trait) {
        CompoundNBT traits = ((CompoundNBT)this.entity.getTrackedValue(TRAITS)).func_74737_b();
        traits.func_82580_o(trait.name());
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void randomize() {
        float total = (float)Arrays.stream(Trait.values()).mapToDouble(tr -> ((Trait)tr).chance).sum();
        for (Trait t : Trait.values()) {
            float chance = Config.getInstance().traitChance / total * t.chance;
            if (!(this.random.nextFloat() < chance)) continue;
            this.addTrait(t);
        }
    }

    public void inherit(Traits from) {
        for (Trait t : from.getInheritedTraits()) {
            this.addTrait(t);
        }
    }

    public void inherit(Traits from, long seed) {
        Random old = this.random;
        this.random = new Random(seed);
        this.inherit(from);
        this.random = old;
    }

    public float getVerticalScaleFactor() {
        return this.hasTrait(Trait.DWARFISM) ? 0.65f : 1.0f;
    }

    public float getHorizontalScaleFactor() {
        return this.hasTrait(Trait.DWARFISM) ? 0.85f : 1.0f;
    }

    public static enum Trait {
        LEFT_HANDED(1.0f, 0.5f, false),
        COLOR_BLIND(1.0f, 0.5f),
        HETEROCHROMIA(1.0f, 2.0f),
        LACTOSE_INTOLERANCE(1.0f, 1.0f),
        COELIAC_DISEASE(1.0f, 1.0f, false),
        DIABETES(1.0f, 1.0f, false),
        DWARFISM(1.0f, 1.0f),
        ALBINISM(1.0f, 1.0f),
        VEGETARIAN(1.0f, 0.0f, false),
        BISEXUAL(1.0f, 0.0f),
        HOMOSEXUAL(1.0f, 0.0f),
        ELECTRIFIED(0.0f, 0.0f, false),
        SIRBEN(0.025f, 1.0f, false),
        RAINBOW(0.05f, 0.0f);

        private final float chance;
        private final float inherit;
        private final boolean usableOnPlayer;

        private Trait(float chance, float inherit, boolean usableOnPlayer) {
            this.chance = chance;
            this.inherit = inherit;
            this.usableOnPlayer = usableOnPlayer;
        }

        private Trait(float chance, float inherit) {
            this(chance, inherit, true);
        }

        public ITextComponent getName() {
            return new TranslationTextComponent("trait." + this.name().toLowerCase(Locale.ENGLISH));
        }

        public ITextComponent getDescription() {
            return new TranslationTextComponent("traitDescription." + this.name().toLowerCase(Locale.ENGLISH));
        }

        public boolean isUsableOnPlayer() {
            return this.usableOnPlayer;
        }
    }
}

