/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain;

import forge.net.mca.Config;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.entity.EntityWrapper;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.ActivityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import forge.net.mca.entity.ai.Mood;
import forge.net.mca.entity.ai.MoodGroup;
import forge.net.mca.entity.ai.MoveState;
import forge.net.mca.entity.ai.relationship.Personality;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CEnumParameter;
import forge.net.mca.util.network.datasync.CParameter;
import forge.net.mca.util.network.datasync.CTrackedEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class VillagerBrain<E extends MobEntity> {
    private static final CDataParameter<CompoundNBT> MEMORIES = CParameter.create("memories", new CompoundNBT());
    private static final CEnumParameter<Personality> PERSONALITY = CParameter.create("personality", Personality.UNASSIGNED);
    private static final CDataParameter<Integer> MOOD = CParameter.create("mood", 0);
    private static final CEnumParameter<MoveState> MOVE_STATE = CParameter.create("moveState", MoveState.MOVE);
    private static final CEnumParameter<Chore> ACTIVE_CHORE = CParameter.create("activeChore", Chore.NONE);
    private static final CDataParameter<Optional<UUID>> CHORE_ASSIGNING_PLAYER = CParameter.create("choreAssigningPlayer", Optional.empty());
    private static final CDataParameter<Boolean> PANICKING = CParameter.create("isPanicking", false);
    private static final CDataParameter<Boolean> WEAR_ARMOR = CParameter.create("wearArmor", false);
    private final E entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(MEMORIES, PERSONALITY, MOOD, MOVE_STATE, ACTIVE_CHORE, CHORE_ASSIGNING_PLAYER, PANICKING, WEAR_ARMOR);
    }

    public VillagerBrain(E entity) {
        this.entity = entity;
    }

    public void think() {
        CompoundNBT nbt;
        boolean panicking;
        if (((CTrackedEntity)this.entity).getTrackedValue(ACTIVE_CHORE) != Chore.NONE) {
            this.entity.func_213375_cj().func_233716_f_().ifPresent(activity -> {
                if (!activity.equals(ActivityMCA.CHORE.get())) {
                    this.entity.func_213375_cj().func_218202_a((Activity)ActivityMCA.CHORE.get());
                }
            });
        }
        if ((panicking = this.entity.func_213375_cj().func_218214_c(Activity.field_221371_g)) != (Boolean)((CTrackedEntity)this.entity).getTrackedValue(PANICKING)) {
            ((CTrackedEntity)this.entity).setTrackedValue(PANICKING, panicking);
        }
        if (((MobEntity)this.entity).field_70173_aa % 20 != 0) {
            this.updateMoveState();
        }
        if (((MobEntity)this.entity).field_70173_aa % Math.max(1, Config.getInstance().interactionFatigueCooldown) == 0 && (nbt = (CompoundNBT)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES)) != null) {
            for (String uuid : nbt.func_150296_c()) {
                Memories memories = Memories.fromCNBT(this.entity, nbt.func_74775_l(uuid));
                int fatigue = memories.getInteractionFatigue();
                if (fatigue <= 0) continue;
                memories.setInteractionFatigue(fatigue - 1);
            }
        }
    }

    public Chore getCurrentJob() {
        return (Chore)((Object)((CTrackedEntity)this.entity).getTrackedValue(ACTIVE_CHORE));
    }

    public Optional<PlayerEntity> getJobAssigner() {
        return ((Optional)((CTrackedEntity)this.entity).getTrackedValue(CHORE_ASSIGNING_PLAYER)).map(id -> ((MobEntity)this.entity).field_70170_p.func_217371_b(id));
    }

    public void abandonJob() {
        this.entity.func_213375_cj().func_218202_a(Activity.field_221366_b);
        ((CTrackedEntity)this.entity).setTrackedValue(ACTIVE_CHORE, Chore.NONE);
        ((CTrackedEntity)this.entity).setTrackedValue(CHORE_ASSIGNING_PLAYER, Optional.empty());
        this.resetsBrain();
    }

    public void assignJob(Chore chore, PlayerEntity player) {
        this.entity.func_213375_cj().func_218202_a((Activity)ActivityMCA.CHORE.get());
        ((CTrackedEntity)this.entity).setTrackedValue(ACTIVE_CHORE, chore);
        ((CTrackedEntity)this.entity).setTrackedValue(CHORE_ASSIGNING_PLAYER, Optional.of(player.func_110124_au()));
        this.entity.func_213375_cj().func_218189_b((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get());
        this.entity.func_213375_cj().func_218189_b((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get());
        this.resetsBrain();
    }

    public void randomize() {
        ((CTrackedEntity)this.entity).setTrackedValue(PERSONALITY, Personality.getRandom());
        ((CTrackedEntity)this.entity).setTrackedValue(MOOD, ((MobEntity)this.entity).field_70170_p.field_73012_v.nextInt(31) + -15);
    }

    public void setPersonality(Personality p) {
        ((CTrackedEntity)this.entity).setTrackedValue(PERSONALITY, p);
    }

    public void updateMemories(Memories memories) {
        CompoundNBT nbt = (CompoundNBT)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        nbt = nbt == null ? new CompoundNBT() : nbt.func_74737_b();
        nbt.func_218657_a(memories.getPlayerUUID().toString(), (INBT)memories.toCNBT());
        ((CTrackedEntity)this.entity).setTrackedValue(MEMORIES, nbt);
    }

    public Map<UUID, Memories> getMemories() {
        CompoundNBT nbt = (CompoundNBT)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        HashMap<UUID, Memories> memories = new HashMap<UUID, Memories>();
        for (String uuid : nbt.func_150296_c()) {
            memories.put(UUID.fromString(uuid), Memories.fromCNBT(this.entity, nbt.func_74775_l(uuid)));
        }
        return memories;
    }

    public Memories getMemoriesForPlayer(PlayerEntity player) {
        CompoundNBT nbt = (CompoundNBT)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        nbt = nbt == null ? new CompoundNBT() : nbt;
        CompoundNBT compoundTag = nbt.func_74775_l(player.func_110124_au().toString());
        Memories returnMemories = Memories.fromCNBT(this.entity, compoundTag);
        if (returnMemories == null) {
            returnMemories = new Memories(this, player.field_70170_p.func_72820_D(), player.func_110124_au());
            nbt.func_218657_a(player.func_110124_au().toString(), (INBT)returnMemories.toCNBT());
            ((CTrackedEntity)this.entity).setTrackedValue(MEMORIES, nbt);
        }
        return returnMemories;
    }

    public Personality getPersonality() {
        return (Personality)((Object)((CTrackedEntity)this.entity).getTrackedValue(PERSONALITY));
    }

    public Mood getMood() {
        return this.getPersonality().getMoodGroup().getMood((Integer)((CTrackedEntity)this.entity).getTrackedValue(MOOD));
    }

    public boolean isPanicking() {
        return (Boolean)((CTrackedEntity)this.entity).getTrackedValue(PANICKING);
    }

    public void modifyMoodValue(int mood) {
        ((CTrackedEntity)this.entity).setTrackedValue(MOOD, MoodGroup.clampMood(this.getMoodValue() + mood));
    }

    public int getMoodValue() {
        return (Integer)((CTrackedEntity)this.entity).getTrackedValue(MOOD);
    }

    public MoveState getMoveState() {
        return (MoveState)((Object)((CTrackedEntity)this.entity).getTrackedValue(MOVE_STATE));
    }

    public void setMoveState(MoveState state, @Nullable PlayerEntity leader) {
        ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, state);
        if (state == MoveState.MOVE) {
            this.entity.func_213375_cj().func_218189_b((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get());
            this.entity.func_213375_cj().func_218189_b((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get());
        }
        if (state == MoveState.STAY) {
            this.entity.func_213375_cj().func_218189_b((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get());
            this.entity.func_213375_cj().func_218205_a((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get(), (Object)true);
        }
        if (state == MoveState.FOLLOW) {
            this.entity.func_213375_cj().func_218205_a((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get(), (Object)leader);
            this.entity.func_213375_cj().func_218189_b((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get());
            this.abandonJob();
        }
        this.resetsBrain();
    }

    private void resetsBrain() {
        if (((EntityWrapper)this.entity).asEntity() instanceof VillagerEntityMCA) {
            VillagerEntityMCA villager = (VillagerEntityMCA)((EntityWrapper)this.entity).asEntity();
            villager.func_213770_a((ServerWorld)villager.field_70170_p);
        }
    }

    public void setArmorWear(boolean s) {
        ((CTrackedEntity)this.entity).setTrackedValue(WEAR_ARMOR, s);
    }

    public boolean getArmorWear() {
        return (Boolean)((CTrackedEntity)this.entity).getTrackedValue(WEAR_ARMOR);
    }

    public void updateMoveState() {
        if (this.getMoveState() == MoveState.FOLLOW && !this.entity.func_213375_cj().func_218207_c((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()).isPresent()) {
            if (this.entity.func_213375_cj().func_218207_c((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get()).isPresent()) {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.STAY);
            } else if (this.entity.func_213375_cj().func_218207_c((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()).isPresent()) {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.FOLLOW);
            } else {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.MOVE);
            }
        }
    }

    public void rewardHearts(ServerPlayerEntity player, int hearts) {
        Memories memory = ((VillagerLike)this.entity).getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player);
        if (hearts == 0) {
            return;
        }
        if (hearts > 0) {
            ((MobEntity)this.entity).field_70170_p.func_72960_a(this.entity, (byte)16);
        } else {
            ((MobEntity)this.entity).field_70170_p.func_72960_a(this.entity, (byte)15);
            if (((VillagerLike)this.entity).getVillagerBrain().getPersonality() == Personality.SENSITIVE) {
                hearts *= 2;
            }
        }
        memory.modInteractionFatigue(1);
        memory.modHearts(hearts);
        CriterionMCA.HEARTS_CRITERION.trigger(player, memory.getHearts(), hearts, "interaction");
        ((VillagerLike)this.entity).getVillagerBrain().modifyMoodValue(hearts);
    }
}

