/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.EquipmentSet;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.ActivityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import forge.net.mca.entity.ai.SchedulesMCA;
import forge.net.mca.entity.ai.brain.tasks.BowTask;
import forge.net.mca.entity.ai.brain.tasks.EnterBuildingTask;
import forge.net.mca.entity.ai.brain.tasks.EnterFavoredBuildingTask;
import forge.net.mca.entity.ai.brain.tasks.EquipmentTask;
import forge.net.mca.entity.ai.brain.tasks.ExtendedMeleeAttackTask;
import forge.net.mca.entity.ai.brain.tasks.ExtendedSleepTask;
import forge.net.mca.entity.ai.brain.tasks.FollowTask;
import forge.net.mca.entity.ai.brain.tasks.GreetPlayerTask;
import forge.net.mca.entity.ai.brain.tasks.InteractTask;
import forge.net.mca.entity.ai.brain.tasks.LoseUnimportantJobTask;
import forge.net.mca.entity.ai.brain.tasks.PatrolVillageTask;
import forge.net.mca.entity.ai.brain.tasks.ShoutTask;
import forge.net.mca.entity.ai.brain.tasks.StayTask;
import forge.net.mca.entity.ai.brain.tasks.WanderOrTeleportToTargetTask;
import forge.net.mca.entity.ai.brain.tasks.chore.ChoppingTask;
import forge.net.mca.entity.ai.brain.tasks.chore.FishingTask;
import forge.net.mca.entity.ai.brain.tasks.chore.HarvestingTask;
import forge.net.mca.entity.ai.brain.tasks.chore.HuntingTask;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.server.world.data.Village;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.AssignProfessionTask;
import net.minecraft.entity.ai.brain.task.AttackStrafingTask;
import net.minecraft.entity.ai.brain.task.BeginRaidTask;
import net.minecraft.entity.ai.brain.task.BoneMealCropsTask;
import net.minecraft.entity.ai.brain.task.CelebrateRaidVictoryTask;
import net.minecraft.entity.ai.brain.task.ClearHurtTask;
import net.minecraft.entity.ai.brain.task.CongregateTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.ExpireHidingTask;
import net.minecraft.entity.ai.brain.task.ExpirePOITask;
import net.minecraft.entity.ai.brain.task.FarmTask;
import net.minecraft.entity.ai.brain.task.FarmerWorkTask;
import net.minecraft.entity.ai.brain.task.FindHidingPlaceDuringRaidTask;
import net.minecraft.entity.ai.brain.task.FindHidingPlaceTask;
import net.minecraft.entity.ai.brain.task.FindInteractionAndLookTargetTask;
import net.minecraft.entity.ai.brain.task.FindJobTask;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.FindPotentialJobTask;
import net.minecraft.entity.ai.brain.task.FindWalkTargetAfterRaidVictoryTask;
import net.minecraft.entity.ai.brain.task.FindWalkTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.ForgetRaidTask;
import net.minecraft.entity.ai.brain.task.GatherPOITask;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.ai.brain.task.GoOutsideAfterRaidTask;
import net.minecraft.entity.ai.brain.task.HideFromRaidOnBellRingTask;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.JumpOnBedTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.MultiTask;
import net.minecraft.entity.ai.brain.task.PanicTask;
import net.minecraft.entity.ai.brain.task.PickupWantedItemTask;
import net.minecraft.entity.ai.brain.task.RingBellTask;
import net.minecraft.entity.ai.brain.task.RunAwayTask;
import net.minecraft.entity.ai.brain.task.ShareItemsTask;
import net.minecraft.entity.ai.brain.task.ShootTargetTask;
import net.minecraft.entity.ai.brain.task.ShowWaresTask;
import net.minecraft.entity.ai.brain.task.SpawnGolemTask;
import net.minecraft.entity.ai.brain.task.StayNearPointTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.SwitchVillagerJobTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.TradeTask;
import net.minecraft.entity.ai.brain.task.UpdateActivityTask;
import net.minecraft.entity.ai.brain.task.WakeUpTask;
import net.minecraft.entity.ai.brain.task.WalkRandomlyInsideTask;
import net.minecraft.entity.ai.brain.task.WalkToHouseTask;
import net.minecraft.entity.ai.brain.task.WalkToPOITask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkToVillagerBabiesTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsPosTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsRandomSecondaryPosTask;
import net.minecraft.entity.ai.brain.task.WorkTask;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Items;
import net.minecraft.village.PointOfInterestType;

public class VillagerTasksMCA {
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleType.field_234101_d_, (Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220947_h, (Object)MemoryModuleType.field_220948_i, (Object)MemoryModuleType.field_220949_j, (Object)MemoryModuleType.field_234102_l_, (Object)MemoryModuleType.field_234076_J_, (Object)MemoryModuleType.field_220950_k, (Object[])new MemoryModuleType[]{MemoryModuleType.field_220951_l, MemoryModuleType.field_220952_m, MemoryModuleType.field_220953_n, MemoryModuleType.field_220954_o, MemoryModuleType.field_225462_q, MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_220944_e, MemoryModuleType.field_220961_v, MemoryModuleType.field_220962_w, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y, MemoryModuleType.field_226332_A_, MemoryModuleType.field_223544_z, MemoryModuleType.field_242309_E, MemoryModuleType.field_234103_o_, MemoryModuleType.field_234104_p_, (MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get(), (MemoryModuleType)MemoryModuleTypeMCA.STAYING.get(), (MemoryModuleType)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get(), (MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get(), (MemoryModuleType)MemoryModuleTypeMCA.SMALL_BOUNTY.get(), (MemoryModuleType)MemoryModuleTypeMCA.HIT_BY_PLAYER.get()});
    public static final ImmutableList<SensorType<? extends Sensor<? super VillagerEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_234129_b_, (Object)SensorType.field_221001_e, (Object)SensorType.field_221002_f, (Object)SensorType.field_221003_g, (Object)SensorType.field_221005_i, (Object)SensorType.field_242317_j, (Object)((SensorType)ActivityMCA.VILLAGER_BABIES.get()), (Object)((SensorType)ActivityMCA.EXPLODING_CREEPER.get()), (Object)((SensorType)ActivityMCA.GUARD_ENEMIES.get()));

    public static Brain.BrainCodec<VillagerEntityMCA> createProfile() {
        return Brain.func_233705_a_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<VillagerEntityMCA> initializeTasks(VillagerEntityMCA villager, Brain<VillagerEntityMCA> brain) {
        VillagerProfession profession = villager.func_213700_eh().func_221130_b();
        AgeState age = AgeState.byCurrentAge(villager.func_70874_b());
        boolean noDefault = false;
        if (brain.func_218207_c((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get()).isPresent()) {
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getStayingPackage());
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getSelfDefencePackage());
            brain.func_218208_a(Activity.field_221371_g, VillagerTasksMCA.getPanicPackage(0.5f));
            noDefault = true;
        } else if (brain.func_218207_c((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()).isPresent()) {
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getFollowingPackage());
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getSelfDefencePackage());
            brain.func_218208_a(Activity.field_221371_g, VillagerTasksMCA.getPanicPackage(0.5f));
            noDefault = true;
        } else if (profession == ProfessionsMCA.ADVENTURER.get()) {
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.func_218208_a(Activity.field_221366_b, VillagerTasksMCA.getAdventurerPackage(0.5f));
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getSelfDefencePackage());
            brain.func_218208_a(Activity.field_221371_g, VillagerTasksMCA.getPanicPackage(0.5f));
            noDefault = true;
        } else if (profession == ProfessionsMCA.MERCENARY.get()) {
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.func_218208_a(Activity.field_221366_b, VillagerTasksMCA.getMercenaryPackage(0.5f));
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getGuardCorePackage(villager));
            brain.func_218208_a(Activity.field_221371_g, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.func_218208_a((Activity)ActivityMCA.CHORE.get(), VillagerTasksMCA.getChorePackage());
            noDefault = true;
        } else {
            if (age == AgeState.BABY) {
                brain.func_218203_a(Schedule.field_221385_c);
                return brain;
            }
            if (age != AgeState.ADULT) {
                brain.func_218203_a(Schedule.field_221385_c);
                brain.func_218208_a(Activity.field_221368_d, VillagerTasksMCA.getPlayPackage(0.5f));
                brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getSelfDefencePackage());
            } else if (villager.isGuard()) {
                brain.func_218203_a(SchedulesMCA.getTypeSchedule((LivingEntity)villager, SchedulesMCA.GUARD, SchedulesMCA.GUARD_NIGHT));
                brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getGuardCorePackage(villager));
                brain.func_218208_a(Activity.field_221367_c, VillagerTasksMCA.getGuardWorkPackage());
                brain.func_218208_a(Activity.field_221371_g, VillagerTasksMCA.getGuardPanicPackage(0.5f));
                brain.func_218208_a(Activity.field_221372_h, VillagerTasksMCA.getGuardWorkPackage());
            } else if (profession == ProfessionsMCA.OUTLAW.get() || profession == ProfessionsMCA.CULTIST.get()) {
                brain.func_218203_a(SchedulesMCA.getTypeSchedule((LivingEntity)villager, true));
            } else {
                brain.func_218203_a(SchedulesMCA.getTypeSchedule((LivingEntity)villager));
                brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getWorkingCorePackage(profession, 0.5f));
                brain.func_233700_a_(Activity.field_221367_c, VillagerTasksMCA.getWorkPackage(profession, 0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleStatus.VALUE_PRESENT)));
                brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getSelfDefencePackage());
                brain.func_218208_a(Activity.field_221372_h, VillagerTasksMCA.getRaidPackage(0.5f));
            }
        }
        if (!noDefault) {
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.func_218208_a(Activity.field_221365_a, VillagerTasksMCA.getCorePackage(0.5f));
            brain.func_233700_a_(Activity.field_221370_f, VillagerTasksMCA.getMeetPackage(0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleStatus.VALUE_PRESENT)));
            brain.func_218208_a(Activity.field_221369_e, VillagerTasksMCA.getRestPackage(0.5f));
            brain.func_218208_a(Activity.field_221366_b, VillagerTasksMCA.getIdlePackage(0.5f));
            brain.func_218208_a(Activity.field_221371_g, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.func_218208_a(Activity.field_221373_i, VillagerTasksMCA.getPreRaidPackage(0.5f));
            brain.func_218208_a(Activity.field_221374_j, VillagerTasksMCA.getHidePackage(0.5f));
            brain.func_218208_a((Activity)ActivityMCA.CHORE.get(), VillagerTasksMCA.getChorePackage());
            brain.func_218208_a((Activity)ActivityMCA.GRIEVE.get(), VillagerTasksMCA.getGrievingPackage());
        }
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_218202_a(Activity.field_221366_b);
        brain.func_218211_a(villager.field_70170_p.func_72820_D(), villager.field_70170_p.func_82737_E());
        return brain;
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getStayingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new StayTask())), VillagerTasksMCA.getFullLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getFollowingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new FollowTask())), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getImportantCorePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new SwimTask(0.8f)), (Object)Pair.of((Object)0, (Object)new InteractWithDoorTask()), (Object)Pair.of((Object)0, (Object)new LookTask(45, 90)), (Object)Pair.of((Object)1, (Object)((Object)new WanderOrTeleportToTargetTask())), (Object)Pair.of((Object)3, (Object)((Object)new InteractTask(speedModifier))));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getCorePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GreetPlayerTask())), (Object)Pair.of((Object)0, (Object)new WakeUpTask()), (Object)Pair.of((Object)0, (Object)new HideFromRaidOnBellRingTask()), (Object)Pair.of((Object)0, (Object)new BeginRaidTask()), (Object)Pair.of((Object)5, (Object)new PickupWantedItemTask(speedModifier, false, 4)), (Object)Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.field_221070_r, MemoryModuleType.field_220943_d, true, Optional.of((byte)14))));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getWorkingCorePackage(VillagerProfession profession, float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new ExpirePOITask(profession.func_221149_b(), MemoryModuleType.field_220942_c)), (Object)Pair.of((Object)0, (Object)new ExpirePOITask(profession.func_221149_b(), MemoryModuleType.field_234101_d_)), (Object)Pair.of((Object)2, (Object)new SwitchVillagerJobTask(profession)), (Object)Pair.of((Object)3, (Object)new TradeTask(speedModifier)), (Object)Pair.of((Object)6, (Object)new GatherPOITask(profession.func_221149_b(), MemoryModuleType.field_220942_c, MemoryModuleType.field_234101_d_, true, Optional.empty())), (Object)Pair.of((Object)7, (Object)new FindPotentialJobTask(speedModifier)), (Object)Pair.of((Object)8, (Object)new FindJobTask(speedModifier)), (Object)Pair.of((Object)10, (Object)new AssignProfessionTask()), (Object)Pair.of((Object)10, (Object)((Object)new LoseUnimportantJobTask())));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getSelfDefencePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new PanicTask()), (Object)Pair.of((Object)1, (Object)((Object)new EquipmentTask(VillagerTasksMCA::isInDanger, v -> EquipmentSet.NAKED))), (Object)Pair.of((Object)2, (Object)((Object)new ExtendedMeleeAttackTask(15, 2.5f, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.field_220959_t))));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getGuardCorePackage(VillagerEntityMCA villager) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new SupplementedTask(VillagerTasksMCA::guardTooHurt, (Task)new PanicTask())), (Object)Pair.of((Object)0, (Object)((Object)new ShoutTask("villager.retreat", 100, e -> VillagerTasksMCA.guardTooHurt(e) && e.getVillagerBrain().isPanicking()))), (Object)Pair.of((Object)0, (Object)((Object)new ShoutTask("villager.attack", 160, e -> !VillagerTasksMCA.guardTooHurt(e) && VillagerTasksMCA.getPreferredTarget(e).isPresent()))), (Object)Pair.of((Object)0, (Object)new SupplementedTask(VillagerTasksMCA::guardTooHurt, (Task)new ExtendedMeleeAttackTask(15, 2.5f, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.field_220959_t))), (Object)Pair.of((Object)1, (Object)((Object)new EquipmentTask(VillagerTasksMCA::isOnDuty, v -> v.getResidency().getHomeVillage().map(vil -> vil.getGuardEquipment(v.getProfession(), v.getDominantHand())).orElse(Village.getEquipmentFor(v.getDominantHand(), EquipmentSet.GUARD_0, EquipmentSet.GUARD_0_LEFT))))), (Object)Pair.of((Object)2, (Object)new ForgetAttackTargetTask(t -> true, VillagerTasksMCA::getPreferredTarget)), (Object)Pair.of((Object)3, (Object)new FindNewAttackTargetTask(livingEntity -> !VillagerTasksMCA.isPreferredTarget(villager, livingEntity))), (Object)Pair.of((Object)4, new BowTask(20, 12)), (Object)Pair.of((Object)5, (Object)new SupplementedTask(v -> v.func_233631_a_(Items.field_222114_py), (Task)new AttackStrafingTask(5, 0.75f))), (Object)Pair.of((Object)6, (Object)new MoveToTargetTask(0.75f)), (Object)Pair.of((Object)7, (Object)((Object)new ExtendedMeleeAttackTask(20, 2.0f))), (Object)Pair.of((Object)8, (Object)new ShootTargetTask()), (Object[])new Pair[0]);
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getGuardWorkPackage() {
        return ImmutableList.of((Object)Pair.of((Object)10, (Object)((Object)new PatrolVillageTask(4, 0.4f))), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getGuardPanicPackage(float speedModifier) {
        float f = speedModifier * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)new ClearHurtTask()), (Object)Pair.of((Object)2, (Object)RunAwayTask.func_233965_b_((MemoryModuleType)MemoryModuleType.field_220959_t, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)2, (Object)RunAwayTask.func_233965_b_((MemoryModuleType)MemoryModuleType.field_220958_s, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)new FindWalkTargetTask(f, 2, 2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    private static boolean guardTooHurt(VillagerEntityMCA villager) {
        return (double)villager.func_110143_aJ() < (double)villager.func_110138_aP() * 0.25;
    }

    private static Optional<? extends LivingEntity> getPreferredTarget(VillagerEntityMCA villager) {
        if (VillagerTasksMCA.guardTooHurt(villager)) {
            return Optional.empty();
        }
        Optional primary = villager.func_213375_cj().func_218207_c((MemoryModuleType)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get());
        if (primary.isPresent() && (VillagerTasksMCA.getActivity(villager) != Activity.field_221369_e || (double)((LivingEntity)primary.get()).func_70032_d((Entity)villager) < 8.0)) {
            return primary;
        }
        return villager.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
    }

    private static boolean isPreferredTarget(VillagerEntityMCA villager, LivingEntity entity) {
        Optional<? extends LivingEntity> target = VillagerTasksMCA.getPreferredTarget(villager);
        return target.filter(livingEntity -> livingEntity == entity).isPresent();
    }

    public static boolean isOnDuty(VillagerEntityMCA villager) {
        return VillagerTasksMCA.getActivity(villager) == Activity.field_221367_c || villager.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).isPresent();
    }

    public static boolean isInDanger(VillagerEntityMCA villager) {
        return villager.getVillagerBrain().isPanicking() || villager.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).isPresent();
    }

    private static Activity getActivity(VillagerEntityMCA villager) {
        return villager.func_213375_cj().func_218198_b().func_221377_a((int)(villager.field_70170_p.func_72820_D() % 24000L));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getGrievingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new MultiTask((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.field_220952_m), MultiTask.Ordering.ORDERED, MultiTask.RunType.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new FindWalkTargetTask(1.5f), (Object)1), (Object)Pair.of((Object)new DummyTask(80, 180), (Object)2)))), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getWorkPackage(VillagerProfession profession, float speedModifier) {
        Object villagerWorkTask = profession == VillagerProfession.field_221156_f ? new FarmerWorkTask() : new SpawnGolemTask();
        return ImmutableList.of(VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)villagerWorkTask, (Object)7), (Object)Pair.of((Object)new WorkTask(MemoryModuleType.field_220942_c, 0.4f, 4), (Object)2), (Object)Pair.of((Object)new WalkTowardsPosTask(MemoryModuleType.field_220942_c, 0.4f, 1, 10), (Object)5), (Object)Pair.of((Object)new WalkTowardsRandomSecondaryPosTask(MemoryModuleType.field_220944_e, speedModifier, 1, 6, MemoryModuleType.field_220942_c), (Object)5), (Object)Pair.of((Object)new FarmTask(), (Object)(profession == VillagerProfession.field_221156_f ? 2 : 5)), (Object)Pair.of((Object)new BoneMealCropsTask(), (Object)(profession == VillagerProfession.field_221156_f ? 4 : 7))))), (Object)Pair.of((Object)10, (Object)new ShowWaresTask(400, 1600)), (Object)Pair.of((Object)10, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)2, (Object)new StayNearPointTask(MemoryModuleType.field_220942_c, speedModifier, 9, 100, 1200)), (Object)Pair.of((Object)3, (Object)new GiveHeroGiftsTask(100)), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getPlayPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new WalkToTargetTask(80, 120)), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)5, (Object)new WalkToVillagerBabiesTask()), (Object)Pair.of((Object)5, (Object)new FirstShuffledTask((Map)ImmutableMap.of((Object)MemoryModuleType.field_220947_h, (Object)MemoryModuleStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)EntityType.field_200756_av, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)EntityType.field_220360_g, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)new FindWalkTargetTask(speedModifier), (Object)1), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(speedModifier, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBedTask(speedModifier), (Object)2), (Object)Pair.of((Object)new DummyTask(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getRestPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)3, (Object)((Object)new ExtendedSleepTask(speedModifier))), (Object)Pair.of((Object)5, (Object)new FirstShuffledTask((Map)ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)new WalkToHouseTask(speedModifier), (Object)1), (Object)Pair.of((Object)new WalkRandomlyInsideTask(speedModifier), (Object)4), (Object)Pair.of((Object)new WalkToPOITask(speedModifier, 4), (Object)2), (Object)Pair.of((Object)new DummyTask(20, 40), (Object)2)))), VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getMeetPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new WorkTask(MemoryModuleType.field_220943_d, 0.4f, 40), (Object)2), (Object)Pair.of((Object)new CongregateTask(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new ShowWaresTask(400, 1600)), (Object)Pair.of((Object)10, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)2, (Object)new StayNearPointTask(MemoryModuleType.field_220943_d, speedModifier, 6, 100, 200)), (Object)Pair.of((Object)3, (Object)new GiveHeroGiftsTask(100)), (Object)Pair.of((Object)3, (Object)new ExpirePOITask(PointOfInterestType.field_221070_r, MemoryModuleType.field_220943_d)), (Object)Pair.of((Object)3, (Object)new MultiTask((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.field_220952_m), MultiTask.Ordering.ORDERED, MultiTask.RunType.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new ShareItemsTask(), (Object)1)))), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getIdlePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)((Object)new EnterFavoredBuildingTask(0.5f))), (Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)((EntityType)EntitiesMCA.FEMALE_VILLAGER.get()), (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)((EntityType)EntitiesMCA.MALE_VILLAGER.get()), (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)EntityType.field_220360_g, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)new FindWalkTargetTask(speedModifier), (Object)1), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(speedModifier, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBedTask(speedModifier), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new GiveHeroGiftsTask(100)), (Object)Pair.of((Object)3, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)3, (Object)new ShowWaresTask(400, 1600)), (Object)Pair.of((Object)3, (Object)new MultiTask((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.field_220952_m), MultiTask.Ordering.ORDERED, MultiTask.RunType.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new ShareItemsTask(), (Object)1)))), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getPanicPackage(float speedModifier) {
        float f = speedModifier * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new ClearHurtTask()), (Object)Pair.of((Object)1, (Object)RunAwayTask.func_233965_b_((MemoryModuleType)MemoryModuleType.field_220959_t, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)1, (Object)RunAwayTask.func_233965_b_((MemoryModuleType)MemoryModuleType.field_220958_s, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)new FindWalkTargetTask(f, 2, 2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getPreRaidPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new RingBellTask()), (Object)Pair.of((Object)0, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new StayNearPointTask(MemoryModuleType.field_220943_d, speedModifier * 1.5f, 2, 150, 200), (Object)6), (Object)Pair.of((Object)new FindWalkTargetTask(speedModifier * 1.5f), (Object)2)))), VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)new ForgetRaidTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getRaidPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new GoOutsideAfterRaidTask(speedModifier), (Object)5), (Object)Pair.of((Object)new FindWalkTargetAfterRaidVictoryTask(speedModifier * 1.1f), (Object)2)))), (Object)Pair.of((Object)0, (Object)new CelebrateRaidVictoryTask(600, 600)), (Object)Pair.of((Object)2, (Object)new FindHidingPlaceDuringRaidTask(24, speedModifier * 1.4f)), VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)new ForgetRaidTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getHidePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new ExpireHidingTask(15, 3)), (Object)Pair.of((Object)1, (Object)new FindHidingPlaceTask(32, speedModifier * 1.25f, 2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getChorePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new ChoppingTask())), (Object)Pair.of((Object)0, (Object)((Object)new FishingTask())), (Object)Pair.of((Object)0, (Object)((Object)new HarvestingTask())), (Object)Pair.of((Object)0, (Object)((Object)new HuntingTask())));
    }

    private static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getAdventurerPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)5, (Object)InteractWithEntityTask.func_220445_a((EntityType)((EntityType)EntitiesMCA.FEMALE_VILLAGER.get()), (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)InteractWithEntityTask.func_220445_a((EntityType)((EntityType)EntitiesMCA.MALE_VILLAGER.get()), (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)InteractWithEntityTask.func_220445_a((EntityType)EntityType.field_220360_g, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)new FindWalkTargetTask(speedModifier)), (Object)Pair.of((Object)5, (Object)new WalkTowardsLookTargetTask(speedModifier, 2)), (Object)Pair.of((Object)5, (Object)((Object)new EnterBuildingTask("inn", 0.5f))));
    }

    private static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntityMCA>>> getMercenaryPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)5, (Object)new FindWalkTargetTask(speedModifier)), (Object)Pair.of((Object)5, (Object)new WalkTowardsLookTargetTask(speedModifier, 2)));
    }

    private static Pair<Integer, Task<LivingEntity>> getFullLookBehavior() {
        return Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_220360_g, 8.0f), (Object)8), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200756_av, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.WATER_AMBIENT, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.MONSTER, 8.0f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)2))));
    }

    private static Pair<Integer, Task<LivingEntity>> getMinimalLookBehavior() {
        return Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200756_av, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)8))));
    }
}

