/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.sensor;

import com.google.common.collect.ImmutableSet;
import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;

public class GuardEnemiesSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> func_220974_a() {
        return ImmutableSet.of((Object)((MemoryModuleType)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get()));
    }

    protected void func_212872_a_(ServerWorld world, LivingEntity entity) {
        entity.func_213375_cj().func_218226_a((MemoryModuleType)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get(), this.getNearestHostile(entity));
    }

    private Optional<LivingEntity> getNearestHostile(LivingEntity entity) {
        return this.getVisibleMobs(entity).flatMap(list -> list.stream().filter(this::isHostile).min((a, b) -> this.compareEntities(entity, (LivingEntity)a, (LivingEntity)b)));
    }

    private Optional<List<LivingEntity>> getVisibleMobs(LivingEntity entity) {
        return entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g);
    }

    private int compareEntities(LivingEntity entity, LivingEntity hostile1, LivingEntity hostile2) {
        int i = this.getPriority(hostile2, entity) - this.getPriority(hostile1, entity);
        return i == 0 ? this.compareDistances(entity, hostile1, hostile2) : i;
    }

    private int compareDistances(LivingEntity entity, LivingEntity hostile1, LivingEntity hostile2) {
        return MathHelper.func_76128_c((double)(hostile1.func_70068_e((Entity)entity) - hostile2.func_70068_e((Entity)entity)));
    }

    private int getPriority(LivingEntity entity, LivingEntity guard) {
        if (entity instanceof VillagerEntityMCA) {
            VillagerEntityMCA villager = (VillagerEntityMCA)entity;
            return villager.isHostile() ? 10 : -1;
        }
        if (guard != null && entity instanceof MobEntity && ((MobEntity)entity).func_70638_az() == guard) {
            return 9;
        }
        ResourceLocation id = Registry.field_212629_r.func_177774_c((Object)entity.func_200600_R());
        if (Config.getInstance().guardsTargetEntities.containsKey(id.toString())) {
            return Config.getInstance().guardsTargetEntities.get(id.toString());
        }
        if (Config.getInstance().guardsTargetMonsters && entity instanceof IMob) {
            return 3;
        }
        return -1;
    }

    private boolean isHostile(LivingEntity entity) {
        return this.getPriority(entity, null) >= 0;
    }
}

