/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.Items;
import net.minecraft.world.server.ServerWorld;

public class BowTask<E extends MobEntity>
extends Task<E> {
    private int lastShot;
    private final int fireInterval;
    private final int squaredRange;

    public BowTask(int fireInterval, int range) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT));
        this.fireInterval = fireInterval;
        this.squaredRange = range * range;
    }

    protected boolean shouldRun(ServerWorld serverWorld, E entity) {
        LivingEntity livingEntity = BowTask.getAttackTarget(entity);
        return livingEntity != null && entity.func_233631_a_(Items.field_151031_f) && BrainUtil.func_233876_c_(entity, (LivingEntity)livingEntity) && BrainUtil.func_233869_a_(entity, (LivingEntity)livingEntity, (int)0);
    }

    protected void keepRunning(ServerWorld world, E entity, long time) {
        super.func_212833_d_(world, entity, time);
        LivingEntity target = BowTask.getAttackTarget(entity);
        double d = entity.func_70068_e((Entity)target);
        float backward = 0.0f;
        if (d > (double)((float)this.squaredRange * 1.25f)) {
            backward = 0.5f;
        } else if (d < (double)((float)this.squaredRange * 0.75f)) {
            backward = -0.5f;
        }
        float strafe = (float)(Math.cos((float)time / 20.0f) * 0.5);
        entity.func_70605_aq().func_188488_a(backward, strafe);
        entity.func_70625_a((Entity)target, 30.0f, 30.0f);
        if (((MobEntity)entity).field_70173_aa - this.lastShot > this.fireInterval) {
            ((IRangedAttackMob)entity).func_82196_d(target, 1.0f);
            this.lastShot = ((MobEntity)entity).field_70173_aa;
        }
    }

    protected boolean shouldKeepRunning(ServerWorld world, E entity, long time) {
        return this.shouldRun(world, entity);
    }

    protected void run(ServerWorld world, E entity, long time) {
        entity.func_213395_q(true);
    }

    private static LivingEntity getAttackTarget(LivingEntity entity) {
        return entity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).orElse(null);
    }

    protected void finishRunning(ServerWorld world, E entity, long time) {
        super.func_212835_f_(world, entity, time);
        entity.func_213395_q(false);
    }
}

