/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.server.world.data.Building;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EnterBuildingTask
extends Task<VillagerEntityMCA> {
    private final String building;
    private final float speed;

    public EnterBuildingTask(String building, float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED));
        this.building = building;
        this.speed = speed;
    }

    protected void run(ServerWorld serverWorld, VillagerEntityMCA villager, long l) {
        Optional<BlockPos> blockPos = this.getNextPosition(villager);
        blockPos.ifPresent(pos -> BrainUtil.func_233866_a_((LivingEntity)villager, (BlockPos)pos, (float)this.speed, (int)1));
    }

    protected Optional<Building> getNearestBuilding(VillagerEntityMCA villager) {
        return villager.getResidency().getHomeVillage().flatMap(buildings -> buildings.getBuildings().values().stream().filter(a -> a.getType().equals(this.getBuilding(villager))).min(Comparator.comparingInt(a -> a.getCenter().func_218139_n((Vector3i)villager.func_233580_cy_()))));
    }

    protected Optional<BlockPos> getRandomPositionIn(Building b, World world) {
        Random r = world.func_201674_k();
        BlockPos pos0 = b.getPos0();
        BlockPos pos1 = b.getPos1();
        BlockPos diff = pos1.func_177973_b((Vector3i)pos0);
        int margin = 2;
        for (int attempt = 0; attempt < 16; ++attempt) {
            BlockPos p = pos0.func_177971_a((Vector3i)new BlockPos(r.nextInt(Math.max(1, diff.func_177958_n() - margin * 2)) + margin, r.nextInt(Math.max(1, diff.func_177956_o() - margin * 2)) + margin, r.nextInt(Math.max(1, diff.func_177952_p() - margin * 2)) + margin));
            if (world.func_226660_f_(p)) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    protected Optional<BlockPos> getNextPosition(VillagerEntityMCA villager) {
        Optional<Building> b = this.getNearestBuilding(villager);
        if (b.isPresent() && !b.get().containsPos((Vector3i)villager.func_233580_cy_())) {
            return this.getRandomPositionIn(b.get(), villager.field_70170_p);
        }
        return Optional.empty();
    }

    public String getBuilding(VillagerEntityMCA villager) {
        return this.building;
    }
}

