/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import forge.net.mca.ProfessionsMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.brain.tasks.EnterBuildingTask;
import forge.net.mca.server.world.data.Building;
import java.util.Optional;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class EnterFavoredBuildingTask
extends EnterBuildingTask {
    private int lastMoodIncrease = 0;
    private static final int TICKS_PER_MOOD = 1200;

    public EnterFavoredBuildingTask(float speed) {
        super("", speed);
    }

    @Override
    public String getBuilding(VillagerEntityMCA villager) {
        String building = villager.getVillagerBrain().getMood().getBuilding();
        if (building != null) {
            return building;
        }
        return ProfessionsMCA.getFavoredBuilding(villager.getProfession());
    }

    @Override
    protected Optional<BlockPos> getNextPosition(VillagerEntityMCA villager) {
        Optional<Building> b = this.getNearestBuilding(villager);
        if (b.isPresent()) {
            if (b.get().containsPos((Vector3i)villager.func_233580_cy_())) {
                if (villager.field_70173_aa > this.lastMoodIncrease + 1200 && villager.getVillagerBrain().getMoodValue() < 0) {
                    this.lastMoodIncrease = villager.field_70173_aa;
                    villager.getVillagerBrain().modifyMoodValue(1);
                }
            } else {
                return this.getRandomPositionIn(b.get(), villager.field_70170_p);
            }
        }
        return Optional.empty();
    }
}

