/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.EquipmentSet;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import forge.net.mca.util.InventoryUtils;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.server.ServerWorld;

public class EquipmentTask
extends Task<VillagerEntityMCA> {
    private static final int COOLDOWN = 100;
    private int lastEquipTime;
    private final Predicate<VillagerEntityMCA> condition;
    private final Function<VillagerEntityMCA, EquipmentSet> equipmentSet;
    private boolean lastArmorWearState;

    public EquipmentTask(Predicate<VillagerEntityMCA> condition, Function<VillagerEntityMCA, EquipmentSet> set) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get()), (Object)MemoryModuleStatus.REGISTERED));
        this.condition = condition;
        this.equipmentSet = set;
    }

    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA villager) {
        if (this.lastArmorWearState != villager.getVillagerBrain().getArmorWear()) {
            return true;
        }
        boolean present = villager.func_213375_cj().func_218207_c((MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get()).isPresent();
        if (this.condition.test(villager)) {
            this.lastEquipTime = villager.field_70173_aa;
            return !present || this.equipmentSet.apply(villager).getMainHand() != null && villager.func_184614_ca().func_190926_b();
        }
        if (villager.field_70173_aa - this.lastEquipTime > 100) {
            return present;
        }
        return false;
    }

    private void equipBestArmor(VillagerEntityMCA villager, EquipmentSlotType slot, Item fallback) {
        ItemStack stack = InventoryUtils.getBestArmor((IInventory)villager.func_213715_ed(), slot).orElse(fallback == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)fallback));
        villager.func_184201_a(slot, stack);
    }

    private void equipBestWeapon(VillagerEntityMCA villager, Item fallback) {
        ItemStack stack = InventoryUtils.getBestSword((IInventory)villager.func_213715_ed()).orElse(fallback == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)fallback));
        villager.func_184201_a(villager.getDominantSlot(), stack);
    }

    protected void run(ServerWorld world, VillagerEntityMCA villager, long time) {
        super.func_212831_a_(world, (LivingEntity)villager, time);
        this.lastArmorWearState = villager.getVillagerBrain().getArmorWear();
        EquipmentSet set = this.equipmentSet.apply(villager);
        boolean wear = this.condition.test(villager);
        if (wear) {
            villager.func_213375_cj().func_218205_a((MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get(), (Object)true);
        } else {
            villager.func_213375_cj().func_218189_b((MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get());
        }
        if (wear) {
            this.equipBestWeapon(villager, set.getMainHand());
            villager.func_184201_a(villager.getOpposingSlot(), new ItemStack((IItemProvider)set.getGetOffHand()));
        } else {
            villager.func_184611_a(villager.getDominantHand(), ItemStack.field_190927_a);
            villager.func_184611_a(villager.getOpposingHand(), ItemStack.field_190927_a);
        }
        if (wear || villager.getVillagerBrain().getArmorWear()) {
            this.equipBestArmor(villager, EquipmentSlotType.HEAD, set.getHead());
            this.equipBestArmor(villager, EquipmentSlotType.CHEST, set.getChest());
            this.equipBestArmor(villager, EquipmentSlotType.LEGS, set.getLegs());
            this.equipBestArmor(villager, EquipmentSlotType.FEET, set.getFeet());
        } else {
            villager.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
            villager.func_184201_a(EquipmentSlotType.CHEST, ItemStack.field_190927_a);
            villager.func_184201_a(EquipmentSlotType.LEGS, ItemStack.field_190927_a);
            villager.func_184201_a(EquipmentSlotType.FEET, ItemStack.field_190927_a);
        }
    }
}

