/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerLike;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;

public class ExtendedMeleeAttackTask
extends Task<MobEntity> {
    private final float range;
    private final int interval;
    private final MemoryModuleType<? extends LivingEntity> target;

    public ExtendedMeleeAttackTask(int interval, float range) {
        this(interval, range, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.field_234103_o_);
    }

    public ExtendedMeleeAttackTask(int interval, float range, MemoryModuleType<? extends LivingEntity> target) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, target, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_234104_p_, (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.range = range;
        this.interval = interval;
        this.target = target;
    }

    protected boolean shouldRun(ServerWorld serverWorld, MobEntity attacker) {
        LivingEntity target = this.getTarget(attacker);
        return BrainUtil.func_233876_c_((LivingEntity)attacker, (LivingEntity)target) && this.withinRange((LivingEntity)attacker, target);
    }

    protected void run(ServerWorld serverWorld, MobEntity mobEntity, long l) {
        LivingEntity livingEntity = this.getTarget(mobEntity);
        BrainUtil.func_220625_c((LivingEntity)mobEntity, (LivingEntity)livingEntity);
        if (mobEntity instanceof VillagerLike) {
            VillagerLike villager = (VillagerLike)mobEntity;
            mobEntity.func_184609_a(villager.getDominantHand());
        } else {
            mobEntity.func_184609_a(Hand.MAIN_HAND);
        }
        mobEntity.func_70652_k((Entity)livingEntity);
        mobEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234104_p_, (Object)true, (long)this.interval);
    }

    private boolean withinRange(LivingEntity attacker, LivingEntity target) {
        double r;
        double d = attacker.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        return d <= (r = (double)(attacker.func_213311_cf() + target.func_213311_cf() + this.range));
    }

    private LivingEntity getTarget(MobEntity mobEntity) {
        return (LivingEntity)mobEntity.func_213375_cj().func_218207_c(this.target).get();
    }
}

