/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.server.world.data.Building;
import java.util.Map;
import java.util.Optional;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.server.ServerWorld;

public class ExtendedSleepTask
extends Task<VillagerEntityMCA> {
    private long startTime;
    private final float speed;
    private BlockPos bed;
    private long lastFail = 0L;
    private static final long TICKS_BETWEEN_FAILS = 200L;

    public ExtendedSleepTask(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_226332_A_, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.REGISTERED));
        this.speed = speed;
    }

    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA entity) {
        if (world.func_82737_E() - this.lastFail < 200L) {
            return false;
        }
        boolean b = this.shouldRunInner(world, entity);
        if (!b && entity.func_70608_bn()) {
            entity.func_213366_dy();
        }
        return b;
    }

    private boolean shouldRunInner(ServerWorld world, VillagerEntityMCA entity) {
        long l;
        if (entity.func_184218_aH()) {
            return false;
        }
        Brain brain = entity.func_213375_cj();
        GlobalPos globalPos = (GlobalPos)brain.func_218207_c(MemoryModuleType.field_220941_b).get();
        if (world.func_234923_W_() != globalPos.func_239646_a_()) {
            return false;
        }
        Optional optional = brain.func_218207_c(MemoryModuleType.field_226332_A_);
        if (optional.isPresent() && (l = world.func_82737_E() - (Long)optional.get()) > 0L && l < 100L) {
            return false;
        }
        Optional<Building> building = entity.getResidency().getHomeBuilding();
        if (building.isPresent()) {
            Optional<BlockPos> bed = building.get().findClosestEmptyBed(world, globalPos.func_218180_b());
            if (bed.isPresent()) {
                this.bed = bed.get();
                if (globalPos.func_218180_b().func_218137_a((IPosition)entity.func_213303_ch(), 2.0)) {
                    return true;
                }
                brain.func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(globalPos.func_218180_b(), this.speed, 1));
                return false;
            }
            this.lastFail = world.func_82737_E();
        } else {
            this.lastFail = world.func_82737_E();
        }
        return false;
    }

    protected boolean shouldKeepRunning(ServerWorld world, VillagerEntityMCA entity, long time) {
        if (this.bed != null) {
            return entity.func_213375_cj().func_218214_c(Activity.field_221369_e) && entity.func_226278_cu_() > (double)this.bed.func_177956_o() + 0.4 && this.bed.func_218137_a((IPosition)entity.func_213303_ch(), 1.14);
        }
        return false;
    }

    protected void run(ServerWorld world, VillagerEntityMCA entity, long time) {
        if (time > this.startTime) {
            InteractWithDoorTask.func_242294_a((ServerWorld)world, (LivingEntity)entity, null, null);
            entity.func_213342_e(this.bed);
        }
    }

    protected boolean func_220383_a(long time) {
        return false;
    }

    protected void finishRunning(ServerWorld world, VillagerEntityMCA entity, long time) {
        if (entity.func_70608_bn()) {
            entity.func_213366_dy();
            this.startTime = time + 40L;
        }
    }
}

