/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Relationship;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.server.world.data.Village;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public class GreetPlayerTask
extends Task<VillagerEntityMCA> {
    private static final int MAX_COOLDOWN = 2000;
    private Optional<? extends PlayerEntity> target = Optional.empty();
    private int cooldown;
    private boolean talked;

    public GreetPlayerTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_220952_m, (Object)MemoryModuleStatus.REGISTERED), 600);
    }

    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA villager) {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = 2000;
        Optional<? extends PlayerEntity> player = GreetPlayerTask.getPlayer(villager);
        return player.isPresent() && GreetPlayerTask.isWithinSeeRange(villager, player.get());
    }

    protected void run(ServerWorld world, VillagerEntityMCA villager, long time) {
        this.target = GreetPlayerTask.getPlayer(villager);
        this.target.ifPresent(player -> {
            villager.func_213375_cj().func_218205_a(MemoryModuleType.field_220952_m, player);
            BrainUtil.func_220625_c((LivingEntity)villager, (LivingEntity)player);
            this.talked = false;
        });
    }

    protected boolean shouldKeepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        return !this.talked && !villager.getVillagerBrain().isPanicking() && !villager.func_70608_bn();
    }

    protected void keepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        this.target.ifPresent(player -> {
            BrainUtil.func_220625_c((LivingEntity)villager, (LivingEntity)player);
            if (GreetPlayerTask.isWithinGreetingDistance(villager, player)) {
                Memories memories = villager.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player);
                int day = (int)(villager.field_70170_p.func_72820_D() / 24000L);
                memories.setLastSeen(day);
                String phrase = memories.getHearts() < 0 ? "welcomeFoe" : "welcome";
                villager.sendChatMessage((PlayerEntity)player, phrase, new Object[]{player.func_200200_C_()});
                this.talked = true;
                villager.playWelcomeSound();
            } else {
                BrainUtil.func_233860_a_((LivingEntity)villager, (Entity)player, (float)0.55f, (int)2);
            }
        });
    }

    protected void finishRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        if (!this.talked && this.target.isPresent()) {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer(this.target.get());
            memories.setLastSeen(-1);
        }
        this.target = Optional.empty();
        villager.func_213375_cj().func_218189_b(MemoryModuleType.field_220952_m);
        villager.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        villager.func_213375_cj().func_218189_b(MemoryModuleType.field_220951_l);
    }

    private static Optional<? extends PlayerEntity> getPlayer(VillagerEntityMCA villager) {
        return ((ServerWorld)villager.field_70170_p).func_217369_A().stream().filter(p -> GreetPlayerTask.shouldGreet(villager, p)).findFirst();
    }

    private static boolean shouldGreet(VillagerEntityMCA villager, ServerPlayerEntity player) {
        Optional<Integer> id = PlayerSaveData.get(player).getLastSeenVillageId();
        Optional<Village> village = villager.getResidency().getHomeVillage();
        if (id.isPresent() && village.isPresent() && id.get().intValue() == village.get().getId()) {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player);
            int day = (int)(villager.field_70170_p.func_72820_D() / 24000L);
            if (Relationship.IS_MARRIED.test((CompassionateEntity<?>)villager, (Entity)player) || Relationship.IS_RELATIVE.test((CompassionateEntity<?>)villager, (Entity)player) || Math.abs(memories.getHearts()) >= Config.getInstance().greetHeartsThreshold) {
                long diff = (long)day - memories.getLastSeen();
                if (diff > (long)Config.getInstance().greetAfterDays && memories.getLastSeen() > 0L) {
                    return true;
                }
                if (diff > 0L) {
                    memories.setLastSeen(day);
                }
            } else {
                memories.setLastSeen(day);
            }
        }
        return false;
    }

    private static boolean isWithinGreetingDistance(VillagerEntityMCA villager, PlayerEntity player) {
        return villager.func_233580_cy_().func_218141_a((Vector3i)player.func_233580_cy_(), 3.0);
    }

    private static boolean isWithinSeeRange(VillagerEntityMCA villager, PlayerEntity player) {
        return villager.func_233580_cy_().func_218141_a((Vector3i)player.func_233580_cy_(), 32.0);
    }
}

