/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.util.compat.OptionalCompat;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.IPosWrapper;
import net.minecraft.world.server.ServerWorld;

public class InteractTask
extends Task<VillagerEntityMCA> {
    private final float speedModifier;

    public InteractTask(float speedModifier) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED), Integer.MAX_VALUE);
        this.speedModifier = speedModifier;
    }

    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA villager) {
        return InteractTask.shouldRun(villager);
    }

    public static boolean shouldRun(VillagerEntityMCA villager) {
        return villager.func_70089_S() && villager.getInteractions().getInteractingPlayer().filter(player -> villager.func_70068_e((Entity)player) <= 25.0).isPresent() && !villager.func_70090_H() && !villager.field_70133_I && villager.getVillagerBrain().getCurrentJob() == Chore.NONE;
    }

    protected boolean shouldKeepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager);
    }

    protected void run(ServerWorld world, VillagerEntityMCA villager, long time) {
        this.followPlayer(villager);
    }

    protected void finishRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        Brain brain = villager.func_213375_cj();
        brain.func_218189_b(MemoryModuleType.field_220950_k);
        brain.func_218189_b(MemoryModuleType.field_220951_l);
    }

    protected void keepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        this.followPlayer(villager);
    }

    protected boolean func_220383_a(long time) {
        return false;
    }

    private void followPlayer(VillagerEntityMCA villager) {
        Brain brain = villager.func_213375_cj();
        OptionalCompat.ifPresentOrElse(villager.getInteractions().getInteractingPlayer(), player -> {
            brain.func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget((IPosWrapper)new EntityPosWrapper((Entity)player, false), this.speedModifier, 2));
            brain.func_218205_a(MemoryModuleType.field_220951_l, (Object)new EntityPosWrapper((Entity)player, true));
        }, () -> {
            brain.func_218189_b(MemoryModuleType.field_220950_k);
            brain.func_218189_b(MemoryModuleType.field_220951_l);
        });
    }
}

