/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import forge.net.mca.entity.ai.brain.tasks.InteractTask;
import forge.net.mca.util.BlockBoxExtended;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class PatrolVillageTask
extends Task<VillagerEntityMCA> {
    private final int completionRange;
    private final float speed;

    public PatrolVillageTask(int completionRange, float speed) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()), (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220952_m, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED));
        this.completionRange = completionRange;
        this.speed = speed;
    }

    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA entity) {
        return !InteractTask.shouldRun(entity);
    }

    protected void run(ServerWorld serverWorld, VillagerEntityMCA villager, long l) {
        this.getNextPosition(villager).ifPresent(pos -> BrainUtil.func_233866_a_((LivingEntity)villager, (BlockPos)pos, (float)this.speed, (int)this.completionRange));
    }

    private Optional<BlockPos> getNextPosition(VillagerEntityMCA villager) {
        return villager.getResidency().getHomeVillage().map(village -> {
            BlockBoxExtended box = village.getBox();
            int x = box.field_78897_a + villager.func_70681_au().nextInt(box.func_78883_b());
            int z = box.field_78896_c + villager.func_70681_au().nextInt(box.func_78880_d());
            Vector3d targetPos = new Vector3d((double)x, (double)box.func_215126_f().func_177956_o(), (double)z);
            return RandomPositionGenerator.func_226344_b_((CreatureEntity)villager, (int)32, (int)16, (int)0, (Vector3d)targetPos, (double)1.5707963267948966);
        }).map(BlockPos::new);
    }
}

