/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.gson.JsonSyntaxException;
import forge.net.mca.Config;
import me.shedaniel.architectury.hooks.TagHooks;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class WanderOrTeleportToTargetTask
extends WalkToTargetTask {
    protected boolean func_212832_a_(ServerWorld serverWorld, MobEntity mobEntity) {
        return super.func_212832_a_(serverWorld, mobEntity);
    }

    protected void func_212833_d_(ServerWorld world, MobEntity entity, long l) {
        WalkTarget walkTarget;
        BlockPos targetPos;
        if (Config.getInstance().allowVillagerTeleporting && !(targetPos = (walkTarget = (WalkTarget)entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220950_k).get()).func_220966_a().func_220608_a()).func_218137_a((IPosition)entity.func_213303_ch(), Config.getInstance().villagerMinTeleportationDistance)) {
            this.tryTeleport(world, entity, targetPos);
        }
        super.func_212833_d_(world, entity, l);
    }

    private void tryTeleport(ServerWorld world, MobEntity entity, BlockPos targetPos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomInt(entity, -3, 3);
            int k = this.getRandomInt(entity, -1, 1);
            int l = this.getRandomInt(entity, -3, 3);
            boolean bl = this.tryTeleportTo(world, entity, targetPos, targetPos.func_177958_n() + j, targetPos.func_177956_o() + k, targetPos.func_177952_p() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean tryTeleportTo(ServerWorld world, MobEntity entity, BlockPos targetPos, int x, int y, int z) {
        if (Math.abs((double)x - (double)targetPos.func_177958_n()) < 2.0 && Math.abs((double)z - (double)targetPos.func_177952_p()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(world, entity, new BlockPos(x, y, z))) {
            return false;
        }
        entity.func_70634_a((double)x + 0.5, (double)y, (double)z + 0.5);
        return true;
    }

    private boolean canTeleportTo(ServerWorld world, MobEntity entity, BlockPos pos) {
        PathNodeType pathNodeType = WalkNodeProcessor.func_237231_a_((IBlockReader)world, (BlockPos.Mutable)pos.func_239590_i_());
        if (pathNodeType != PathNodeType.WALKABLE) {
            return false;
        }
        if (!this.isAreaSafe(world, pos.func_177977_b())) {
            return false;
        }
        BlockPos blockPos = pos.func_177973_b((Vector3i)entity.func_233580_cy_());
        return world.func_226665_a__((Entity)entity, entity.func_174813_aQ().func_186670_a(blockPos));
    }

    private int getRandomInt(MobEntity entity, int min, int max) {
        return entity.func_70681_au().nextInt(max - min + 1) + min;
    }

    private boolean isAreaSafe(ServerWorld world, Vector3d pos) {
        return this.isAreaSafe(world, new BlockPos(pos));
    }

    private boolean isAreaSafe(ServerWorld world, BlockPos pos) {
        BlockState aboveState = world.func_180495_p(pos);
        ResourceLocation aboveId = Registry.field_212618_g.func_177774_c((Object)aboveState.func_177230_c());
        for (String blockId : Config.getInstance().villagerPathfindingBlacklist) {
            if (blockId.equals(aboveId.toString())) {
                return false;
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = new ResourceLocation(blockId.substring(1));
            ITag.INamedTag tag = TagHooks.getBlockOptional((ResourceLocation)identifier);
            if (tag != null && !tag.func_230236_b_().isEmpty()) {
                if (!aboveState.func_235714_a_((ITag)tag)) continue;
                return false;
            }
            throw new JsonSyntaxException("Unknown block tag in villagerPathfindingBlacklist '" + identifier + "'");
        }
        return true;
    }
}

