/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks.chore;

import forge.net.mca.MCA;
import forge.net.mca.entity.VillagerEntityMCA;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractChoreTask
extends Task<VillagerEntityMCA> {
    protected VillagerEntityMCA villager;
    protected int failedTicks;
    protected int walkingTicks;
    protected int lastAge;
    protected static final int FAILED_COOLDOWN = 100;
    protected static final int WALKING_THRESHOLD = 200;

    public AbstractChoreTask(Map<MemoryModuleType<?>, MemoryModuleStatus> requirements) {
        super(requirements);
    }

    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA entity) {
        int diff = Math.max(0, entity.field_70173_aa - this.lastAge);
        this.lastAge = entity.field_70173_aa;
        if (this.failedTicks > 0) {
            this.failedTicks -= diff;
            this.walkingTicks += diff;
            if (this.walkingTicks > 200) {
                Optional<Vector3d> optional = Optional.ofNullable(RandomPositionGenerator.func_191377_b((CreatureEntity)entity, (int)10, (int)5));
                entity.func_213375_cj().func_218226_a(MemoryModuleType.field_220950_k, optional.map(vec3d -> new WalkTarget(vec3d, 0.4f, 0)));
                this.walkingTicks = 0;
            }
            return false;
        }
        return this.villager == null || !this.villager.getVillagerBrain().isPanicking();
    }

    protected void keepRunning(ServerWorld world, VillagerEntityMCA entity, long time) {
        if (!this.getAssigningPlayer().isPresent()) {
            MCA.LOGGER.info("Force-stopped chore because assigning player was not present.");
            this.villager.getVillagerBrain().abandonJob();
        }
    }

    protected void run(ServerWorld world, VillagerEntityMCA entity, long time) {
        this.villager = entity;
    }

    Optional<PlayerEntity> getAssigningPlayer() {
        return this.villager.getVillagerBrain().getJobAssigner();
    }

    void abandonJobWithMessage(String message) {
        this.getAssigningPlayer().ifPresent(player -> this.villager.sendChatMessage((PlayerEntity)player, message, new Object[0]));
        this.villager.getVillagerBrain().abandonJob();
    }
}

