/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.TaskUtils;
import forge.net.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import forge.net.mca.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.shedaniel.architectury.hooks.TagHooks;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ChoppingTask
extends AbstractChoreTask {
    private int chopTicks;
    private int targetTreeTicks;
    private BlockPos targetTree;

    public ChoppingTask() {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.CHOP && super.shouldRun(world, villager);
    }

    protected boolean shouldKeepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager);
    }

    protected void finishRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.func_184586_b(villager.getDominantHand());
        if (!stack.func_190926_b()) {
            villager.func_184611_a(villager.getDominantHand(), ItemStack.field_190927_a);
        }
    }

    @Override
    protected void run(ServerWorld world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.func_190630_a(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((IInventory)villager.func_213715_ed(), stack -> stack.func_77973_b() instanceof AxeItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.chopping.noaxe");
            } else {
                villager.func_184611_a(villager.getDominantHand(), villager.func_213715_ed().func_70301_a(i));
            }
        }
    }

    @Override
    protected void keepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((IInventory)villager.func_213715_ed(), AxeItem.class) && !villager.func_190630_a(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.chopping.noaxe");
        } else if (!villager.func_190630_a(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((IInventory)villager.func_213715_ed(), stack -> stack.func_77973_b() instanceof AxeItem);
            ItemStack stack2 = villager.func_213715_ed().func_70301_a(i);
            villager.func_184611_a(villager.getDominantHand(), stack2);
        }
        if (this.targetTree == null) {
            List<BlockPos> nearbyLogs = TaskUtils.getNearbyBlocks(villager.func_233580_cy_(), (World)world, blockState -> blockState.func_235714_a_((ITag)BlockTags.field_200031_h), 15, 5);
            ArrayList<BlockPos> nearbyTrees = new ArrayList<BlockPos>();
            nearbyLogs.stream().filter(log -> this.isTreeStartLog(world, (BlockPos)log)).forEach(nearbyTrees::add);
            this.targetTree = TaskUtils.getNearestPoint(villager.func_233580_cy_(), nearbyTrees);
            if (this.targetTree != null) {
                BlockState state;
                ItemStack stack3 = villager.func_184586_b(villager.getDominantHand());
                BlockPos pos = this.targetTree;
                while ((state = world.func_180495_p(pos)).func_235714_a_((ITag)BlockTags.field_200031_h)) {
                    this.targetTreeTicks = (int)((float)this.targetTreeTicks + (float)this.getTicksFor(state, 60) / stack3.func_150997_a(state));
                    pos = pos.func_177982_a(0, 1, 0);
                }
            }
            this.failedTicks = 100;
            return;
        }
        villager.moveTowards(this.targetTree);
        BlockState state = world.func_180495_p(this.targetTree);
        if (state.func_235714_a_((ITag)BlockTags.field_200031_h)) {
            villager.func_184609_a(villager.getDominantHand());
            ++this.chopTicks;
            if (this.chopTicks >= this.targetTreeTicks) {
                this.chopTicks = 0;
                this.destroyTree(world, this.targetTree);
            }
        } else {
            this.targetTree = null;
            this.targetTreeTicks = 0;
        }
        super.keepRunning(world, villager, time);
    }

    private boolean isTreeStartLog(ServerWorld world, BlockPos origin) {
        if (!world.func_180495_p(origin).func_235714_a_((ITag)BlockTags.field_200031_h)) {
            return false;
        }
        if (!this.isValidTree(world, origin.func_177977_b())) {
            return false;
        }
        BlockPos.Mutable pos_up = origin.func_239590_i_();
        for (int y = 0; y < Config.getInstance().maxTreeHeight; ++y) {
            BlockState up = world.func_180495_p(pos_up.func_177984_a());
            if (up.func_235714_a_((ITag)BlockTags.field_200031_h)) continue;
            return up.func_235714_a_((ITag)BlockTags.field_206952_E);
        }
        return false;
    }

    private void destroyTree(ServerWorld world, BlockPos origin) {
        BlockState state;
        ItemStack stack = this.villager.func_184586_b(this.villager.getDominantHand());
        BlockPos pos = origin;
        while ((state = world.func_180495_p(pos)).func_235714_a_((ITag)BlockTags.field_200031_h)) {
            world.func_225521_a_(pos, false, (Entity)this.villager);
            pos = pos.func_177982_a(0, 1, 0);
            this.villager.func_213715_ed().func_174894_a(new ItemStack((IItemProvider)state.func_177230_c(), 1));
            stack.func_222118_a(1, (LivingEntity)this.villager, e -> e.func_213361_c(e.getDominantSlot()));
        }
    }

    private boolean isValidTree(ServerWorld world, Vector3d pos) {
        return this.isValidTree(world, new BlockPos(pos));
    }

    private boolean isValidTree(ServerWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        ResourceLocation stateId = Registry.field_212618_g.func_177774_c((Object)state.func_177230_c());
        for (String blockId : Config.getInstance().validTreeSources) {
            if (blockId.equals(stateId.toString())) {
                return true;
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = new ResourceLocation(blockId.substring(1));
            ITag.INamedTag tag = TagHooks.getBlockOptional((ResourceLocation)identifier);
            if (tag != null && !tag.func_230236_b_().isEmpty()) {
                if (!state.func_235714_a_((ITag)tag)) continue;
                return true;
            }
            throw new JsonSyntaxException("Unknown block tag in validTreeSources '" + identifier + "'");
        }
        return false;
    }

    private int getTicksFor(BlockState state, int fallback) {
        Map<String, Integer> sources = Config.getInstance().maxTreeTicks;
        ResourceLocation stateId = Registry.field_212618_g.func_177774_c((Object)state.func_177230_c());
        for (String blockId : sources.keySet()) {
            if (blockId.equals(stateId.toString())) {
                return sources.get(blockId);
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = new ResourceLocation(blockId.substring(1));
            ITag.INamedTag tag = TagHooks.getBlockOptional((ResourceLocation)identifier);
            if (tag != null && !tag.func_230236_b_().isEmpty()) {
                if (!state.func_235714_a_((ITag)tag)) continue;
                return sources.get(blockId);
            }
            throw new JsonSyntaxException("Unknown block tag in maxTreeTicks '" + identifier + "'");
        }
        return fallback;
    }
}

