/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.TaskUtils;
import forge.net.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import forge.net.mca.util.InventoryUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class FishingTask
extends AbstractChoreTask {
    private BlockPos targetWater;
    private boolean hasCastRod;
    private int ticks;
    private List<ItemStack> list;

    public FishingTask() {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.FISH && super.shouldRun(world, villager);
    }

    protected boolean shouldKeepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager);
    }

    @Override
    protected void run(ServerWorld world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.func_190630_a(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((IInventory)villager.func_213715_ed(), stack -> stack.func_77973_b() instanceof FishingRodItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.fishing.norod");
            } else {
                villager.func_184611_a(villager.getDominantHand(), villager.func_213715_ed().func_70301_a(i));
            }
        }
        LootTable loottable = world.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
        LootContext.Builder lootcontext$builder = new LootContext.Builder(world).func_216015_a(LootParameters.field_237457_g_, (Object)villager.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)new ItemStack((IItemProvider)Items.field_151112_aM)).func_216015_a(LootParameters.field_216281_a, (Object)villager).func_216023_a(this.villager.func_70681_au()).func_186469_a(0.0f);
        this.list = loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
    }

    @Override
    protected void keepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        super.keepRunning(world, villager, time);
        if (!InventoryUtils.contains((IInventory)villager.func_213715_ed(), FishingRodItem.class) && !villager.func_190630_a(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.fishing.norod");
        } else if (!villager.func_190630_a(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((IInventory)villager.func_213715_ed(), stack -> stack.func_77973_b() instanceof FishingRodItem);
            ItemStack stack2 = villager.func_213715_ed().func_70301_a(i);
            villager.func_184611_a(villager.getDominantHand(), stack2);
        }
        if (this.targetWater == null) {
            List<BlockPos> nearbyStaticLiquid = TaskUtils.getNearbyBlocks(villager.func_233580_cy_(), villager.field_70170_p, blockState -> blockState.func_203425_a(Blocks.field_150355_j), 12, 3);
            this.targetWater = nearbyStaticLiquid.stream().filter(p -> villager.field_70170_p.func_180495_p(p).func_177230_c() == Blocks.field_150355_j).min(Comparator.comparingDouble(d -> villager.func_70092_e(d.func_177958_n(), d.func_177956_o(), d.func_177952_p()))).orElse(null);
            if (this.targetWater == null) {
                this.failedTicks = 100;
            }
        } else if (villager.func_70092_e(this.targetWater.func_177958_n(), this.targetWater.func_177956_o(), this.targetWater.func_177952_p()) < 5.0) {
            villager.func_70661_as().func_75499_g();
            villager.lookAt(this.targetWater);
            if (!this.hasCastRod) {
                villager.func_184609_a(villager.getDominantHand());
                this.hasCastRod = true;
            }
            ++this.ticks;
            if (this.ticks >= villager.field_70170_p.field_73012_v.nextInt(200) + 200) {
                if (villager.field_70170_p.field_73012_v.nextFloat() >= 0.35f) {
                    ItemStack stack3 = this.list.get(villager.func_70681_au().nextInt(this.list.size())).func_77946_l();
                    villager.func_184609_a(villager.getDominantHand());
                    villager.func_213715_ed().func_174894_a(stack3);
                    villager.func_184614_ca().func_222118_a(1, (LivingEntity)villager, e -> e.func_213361_c(e.getDominantSlot()));
                }
                this.ticks = 0;
            }
        } else {
            villager.moveTowards(this.targetWater);
        }
    }

    protected void finishRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.func_184586_b(villager.getDominantHand());
        if (!stack.func_190926_b()) {
            villager.func_184611_a(villager.getDominantHand(), ItemStack.field_190927_a);
        }
    }
}

