/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.TagsMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.TaskUtils;
import forge.net.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import forge.net.mca.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HarvestingTask
extends AbstractChoreTask {
    private static final int TICKS_PER_TURN = 15;
    private static final int ITEM_READY = 0;
    private static final int ITEM_FOUND = 1;
    private static final int ITEM_MISSING = 2;
    private final List<BlockPos> harvestable = new ArrayList<BlockPos>();
    private int lastCropScan = 0;

    public HarvestingTask() {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.HARVEST && super.shouldRun(world, villager);
    }

    protected boolean shouldKeepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager);
    }

    protected void finishRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.func_184586_b(villager.getDominantHand());
        if (!stack.func_190926_b()) {
            villager.func_184611_a(villager.getDominantHand(), ItemStack.field_190927_a);
        }
    }

    @Override
    protected void run(ServerWorld world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.func_190630_a(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((IInventory)villager.func_213715_ed(), stack -> stack.func_77973_b() instanceof HoeItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.harvesting.nohoe");
            } else {
                ItemStack stack2 = villager.func_213715_ed().func_70301_a(i);
                villager.func_184611_a(villager.getDominantHand(), stack2);
            }
        }
    }

    private BlockPos searchCrop(int rangeX, int rangeY, boolean harvestableOnly) {
        List<BlockPos> nearbyCrops = TaskUtils.getNearbyBlocks(this.villager.func_233580_cy_(), this.villager.field_70170_p, blockState -> blockState.func_235714_a_((ITag)BlockTags.field_226152_ab_) || blockState.func_177230_c() instanceof StemGrownBlock, rangeX, rangeY);
        this.harvestable.clear();
        if (harvestableOnly) {
            this.harvestable.addAll(nearbyCrops.stream().filter(pos -> {
                BlockState state = this.villager.field_70170_p.func_180495_p(pos);
                return state.func_177230_c() instanceof CropsBlock && ((CropsBlock)state.func_177230_c()).func_185525_y(state) || state.func_177230_c() instanceof StemGrownBlock;
            }).collect(Collectors.toList()));
        }
        return TaskUtils.getNearestPoint(this.villager.func_233580_cy_(), this.harvestable.isEmpty() ? nearbyCrops : this.harvestable);
    }

    private BlockPos searchUnusedFarmLand(int rangeX, int rangeY) {
        return TaskUtils.getNearestPoint(this.villager.func_233580_cy_(), TaskUtils.getNearbyBlocks(this.villager.func_233580_cy_(), this.villager.field_70170_p, blockState -> blockState.func_203425_a(Blocks.field_150458_ak), rangeX, rangeY).stream().filter(pos -> {
            BlockState state = this.villager.field_70170_p.func_180495_p(pos);
            return state.func_177230_c() instanceof FarmlandBlock && state.func_196955_c((IWorldReader)this.villager.field_70170_p, pos) && this.villager.field_70170_p.func_180495_p(pos.func_177984_a()).func_196958_f();
        }).collect(Collectors.toList()));
    }

    @Override
    protected void keepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        BlockPos crops;
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((IInventory)villager.func_213715_ed(), HoeItem.class) && !villager.func_190630_a(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.harvesting.nohoe");
        } else if (!villager.func_190630_a(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((IInventory)villager.func_213715_ed(), stack -> stack.func_77973_b() instanceof HoeItem);
            ItemStack stack2 = villager.func_213715_ed().func_70301_a(i);
            villager.func_184611_a(villager.getDominantHand(), stack2);
        }
        BlockPos fertileFarmLand = this.searchUnusedFarmLand(16, 3);
        if (fertileFarmLand == null && villager.field_70173_aa - this.lastCropScan > 1200) {
            this.lastCropScan = villager.field_70173_aa;
            fertileFarmLand = this.searchUnusedFarmLand(32, 16);
        }
        if (fertileFarmLand != null && villager.func_175556_cs()) {
            villager.moveTowards(fertileFarmLand);
            if (villager.func_195048_a(Vector3d.func_237492_c_((Vector3i)fertileFarmLand)) <= 6.0 && this.tickAction()) {
                this.plantSeeds(world, villager, fertileFarmLand.func_177984_a());
            }
        }
        if ((crops = this.searchCrop(16, 3, true)) == null && villager.field_70173_aa - this.lastCropScan > 1200) {
            crops = this.searchCrop(32, 16, true);
        }
        if (crops == null) {
            this.failedTicks = 100;
            return;
        }
        if (this.harvestable.isEmpty()) {
            crops = this.searchCrop(16, 3, false);
        }
        villager.moveTowards(crops);
        if (villager.func_195048_a(Vector3d.func_237492_c_((Vector3i)crops)) <= 4.5 && this.tickAction()) {
            BlockState state = world.func_180495_p(crops);
            if (state.func_177230_c() instanceof CropsBlock) {
                CropsBlock crop = (CropsBlock)state.func_177230_c();
                if (crop.func_185525_y(state)) {
                    this.harvestCrops(world, crops);
                    this.plantSeeds(world, villager, crops);
                } else {
                    this.bonemealCrop(world, villager, crops);
                }
            } else if (state.func_177230_c() instanceof StemGrownBlock) {
                this.harvestCrops(world, crops);
            }
        }
    }

    private boolean tickAction() {
        return this.villager.field_70170_p.func_82737_E() % 15L == 0L;
    }

    private int swapItem(Predicate<ItemStack> find) {
        ItemStack stack = this.villager.func_184614_ca();
        if (find.test(stack)) {
            return 0;
        }
        Inventory inventory = this.villager.func_213715_ed();
        int slot = InventoryUtils.getFirstSlotContainingItem((IInventory)inventory, find);
        if (slot < 0) {
            return 2;
        }
        this.villager.func_184611_a(this.villager.getDominantHand(), inventory.func_70301_a(slot));
        return 1;
    }

    private boolean plantSeed(ItemStack itemStack, ServerWorld serverWorld, BlockPos currentTarget) {
        if (itemStack.func_77973_b() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)itemStack.func_77973_b();
            return serverWorld.func_180501_a(currentTarget, blockItem.func_179223_d().func_176223_P(), 3);
        }
        return false;
    }

    private void plantSeeds(ServerWorld world, VillagerEntityMCA villager, BlockPos target) {
        BlockRayTraceResult hitResult = new BlockRayTraceResult(Vector3d.func_237492_c_((Vector3i)target), Direction.DOWN, target, true);
        ActionResultType result = InventoryUtils.stream((IInventory)villager.func_213715_ed()).filter(stack -> !stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem && stack.func_77973_b().func_206844_a(TagsMCA.Items.VILLAGER_PLANTABLE)).filter(stack -> {
            if (this.plantSeed((ItemStack)stack, world, hitResult.func_216350_a())) {
                stack.func_190918_g(1);
                return true;
            }
            return false;
        }).findFirst().map(v -> ActionResultType.SUCCESS).orElse(ActionResultType.FAIL);
        if (result.func_226246_a_()) {
            if (result.func_226247_b_()) {
                villager.func_184609_a(villager.getDominantHand());
            }
        } else if (this.getAssigningPlayer().isPresent()) {
            villager.sendChatMessage(this.getAssigningPlayer().get(), "chore.harvesting.noseed", new Object[0]);
        }
    }

    private void bonemealCrop(ServerWorld world, VillagerEntityMCA villager, BlockPos pos) {
        if (this.swapItem(stack -> stack.func_77973_b() instanceof BoneMealItem) == 0 && BoneMealItem.func_195966_a((ItemStack)villager.func_184582_a(villager.getDominantSlot()), (World)world, (BlockPos)pos)) {
            villager.func_184609_a(villager.getDominantHand());
        }
    }

    private void harvestCrops(ServerWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        LootContext.Builder lootcontext$builder = new LootContext.Builder(world).func_216015_a(LootParameters.field_237457_g_, (Object)this.villager.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216015_a(LootParameters.field_216281_a, (Object)this.villager).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216023_a(this.villager.func_70681_au()).func_186469_a(0.0f);
        List drops = world.func_73046_m().func_200249_aQ().func_186521_a(state.func_177230_c().func_220068_i()).func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216267_h));
        for (ItemStack stack : drops) {
            this.villager.func_213715_ed().func_174894_a(stack);
        }
        world.func_225521_a_(pos, false, (Entity)this.villager);
    }
}

