/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import forge.net.mca.util.InventoryUtils;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.DamageSource;
import net.minecraft.world.server.ServerWorld;

public class HuntingTask
extends AbstractChoreTask {
    private int ticks = 0;
    private int nextAction = 0;
    private AnimalEntity target = null;

    public HuntingTask() {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean shouldRun(ServerWorld world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.HUNT && super.shouldRun(world, villager);
    }

    protected boolean shouldKeepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager);
    }

    protected void finishRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.func_184586_b(villager.getDominantHand());
        if (!stack.func_190926_b()) {
            villager.func_184611_a(villager.getDominantHand(), ItemStack.field_190927_a);
        }
    }

    @Override
    protected void run(ServerWorld world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.func_190630_a(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((IInventory)villager.func_213715_ed(), stack -> stack.func_77973_b() instanceof SwordItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.hunting.nosword");
            } else {
                ItemStack stack2 = villager.func_213715_ed().func_70301_a(i);
                villager.func_184611_a(villager.getDominantHand(), stack2);
            }
        }
    }

    @Override
    protected void keepRunning(ServerWorld world, VillagerEntityMCA villager, long time) {
        super.keepRunning(world, villager, time);
        if (!InventoryUtils.contains((IInventory)villager.func_213715_ed(), SwordItem.class) && !villager.func_190630_a(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.hunting.nosword");
        } else if (!villager.func_190630_a(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((IInventory)villager.func_213715_ed(), stack -> stack.func_77973_b() instanceof SwordItem);
            ItemStack stack2 = villager.func_213715_ed().func_70301_a(i);
            villager.func_184611_a(villager.getDominantHand(), stack2);
        }
        if (this.target == null) {
            ++this.ticks;
            if (this.ticks >= this.nextAction) {
                this.ticks = 0;
                if ((double)villager.field_70170_p.field_73012_v.nextFloat() >= 0.0) {
                    villager.field_70170_p.func_217357_a(AnimalEntity.class, villager.func_174813_aQ().func_72314_b(15.0, 3.0, 15.0)).stream().filter(a -> !(a instanceof TameableEntity)).filter(a -> !a.func_70631_g_()).min(Comparator.comparingDouble(arg_0 -> ((VillagerEntityMCA)villager).func_70068_e(arg_0))).ifPresent(animal -> {
                        this.target = animal;
                        villager.moveTowards(this.target.func_233580_cy_(), 1.0f);
                    });
                }
                this.nextAction = 50;
                if (this.target == null) {
                    this.failedTicks = 100;
                }
            }
        } else {
            villager.moveTowards(this.target.func_233580_cy_());
            if (this.target.func_233643_dh_()) {
                villager.field_70170_p.func_217357_a(ItemEntity.class, villager.func_174813_aQ().func_72314_b(15.0, 3.0, 15.0)).forEach(item -> {
                    villager.func_213715_ed().func_174894_a(item.func_92059_d());
                    item.func_70106_y();
                });
                this.target = null;
            } else if (villager.func_70068_e((Entity)this.target) <= 12.25) {
                villager.moveTowards(this.target.func_233580_cy_());
                villager.func_184609_a(villager.getDominantHand());
                this.target.func_70097_a(DamageSource.func_76358_a((LivingEntity)villager), 6.0f);
                villager.func_184614_ca().func_222118_a(1, (LivingEntity)villager, e -> e.func_213361_c(e.getDominantSlot()));
            }
        }
    }
}

