/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.relationship;

import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.entity.ai.relationship.RelationshipType;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.server.world.data.PlayerSaveData;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityRelationship {
    default public Gender getGender() {
        return Gender.MALE;
    }

    default public FamilyTree getFamilyTree() {
        return FamilyTree.get(this.getWorld());
    }

    public ServerWorld getWorld();

    public UUID getUUID();

    @NotNull
    public FamilyTreeNode getFamilyEntry();

    default public Stream<Entity> getFamily(int parents, int children) {
        return this.getFamilyEntry().getRelatives(parents, children).map(arg_0 -> ((ServerWorld)this.getWorld()).func_217461_a(arg_0)).filter(Objects::nonNull).filter(e -> !e.func_110124_au().equals(this.getUUID()));
    }

    default public Stream<Entity> getParents() {
        return this.getFamilyEntry().streamParents().map(arg_0 -> ((ServerWorld)this.getWorld()).func_217461_a(arg_0)).filter(Objects::nonNull);
    }

    default public Stream<Entity> getSiblings() {
        return this.getFamilyEntry().siblings().stream().map(arg_0 -> ((ServerWorld)this.getWorld()).func_217461_a(arg_0)).filter(Objects::nonNull).filter(e -> !e.func_110124_au().equals(this.getUUID()));
    }

    default public Optional<Entity> getPartner() {
        return Optional.ofNullable(this.getWorld().func_217461_a(this.getFamilyEntry().partner()));
    }

    default public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite, RelationshipType type, Entity victim) {
        if (type == RelationshipType.STRANGER) {
            return;
        }
        if (type == RelationshipType.SELF) {
            this.getParents().forEach(parent -> EntityRelationship.of(parent).ifPresent(r -> r.onTragedy(cause, burialSite, RelationshipType.CHILD, victim)));
            this.getSiblings().forEach(sibling -> EntityRelationship.of(sibling).ifPresent(r -> r.onTragedy(cause, burialSite, RelationshipType.SIBLING, victim)));
            this.getPartner().flatMap(EntityRelationship::of).ifPresent(r -> r.onTragedy(cause, burialSite, RelationshipType.SPOUSE, victim));
        }
        if (type == RelationshipType.SPOUSE || type == RelationshipType.SELF) {
            if (this.getRelationshipState().isMarried()) {
                this.endRelationShip(RelationshipState.WIDOW);
            } else {
                this.endRelationShip(RelationshipState.SINGLE);
            }
        }
    }

    default public void marry(Entity spouse) {
        RelationshipState state;
        RelationshipState relationshipState = state = spouse instanceof PlayerEntity ? RelationshipState.MARRIED_TO_PLAYER : RelationshipState.MARRIED_TO_VILLAGER;
        if (spouse instanceof ServerPlayerEntity) {
            ServerPlayerEntity spouseEntity = (ServerPlayerEntity)spouse;
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(spouseEntity, "marriage");
        }
        this.getFamilyEntry().updatePartner(spouse, state);
    }

    default public void engage(Entity spouse) {
        if (spouse instanceof ServerPlayerEntity) {
            ServerPlayerEntity spouseEntity = (ServerPlayerEntity)spouse;
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(spouseEntity, "engage");
        }
        this.getFamilyEntry().updatePartner(spouse, RelationshipState.ENGAGED);
    }

    default public void promise(Entity spouse) {
        if (spouse instanceof ServerPlayerEntity) {
            ServerPlayerEntity spouseEntity = (ServerPlayerEntity)spouse;
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(spouseEntity, "promise");
        }
        this.getFamilyEntry().updatePartner(spouse, RelationshipState.PROMISED);
    }

    default public void endRelationShip(RelationshipState newState) {
        this.getFamilyEntry().updatePartner(null, newState);
    }

    default public RelationshipState getRelationshipState() {
        return this.getFamilyEntry().getRelationshipState();
    }

    default public Optional<UUID> getPartnerUUID() {
        UUID spouse = this.getFamilyEntry().partner();
        if (spouse.equals(Util.field_240973_b_)) {
            return Optional.empty();
        }
        return Optional.of(spouse);
    }

    default public Optional<ITextComponent> getPartnerName() {
        return this.getFamilyTree().getOrEmpty(this.getFamilyEntry().partner()).map(FamilyTreeNode::getName).map(StringTextComponent::new);
    }

    default public boolean isMarried() {
        return this.getRelationshipState() == RelationshipState.MARRIED_TO_PLAYER || this.getRelationshipState() == RelationshipState.MARRIED_TO_VILLAGER;
    }

    default public boolean isEngaged() {
        return this.getRelationshipState() == RelationshipState.ENGAGED;
    }

    default public boolean isPromised() {
        return this.getRelationshipState() == RelationshipState.PROMISED;
    }

    default public boolean isPromisedTo(UUID uuid) {
        return this.getPartnerUUID().orElse(Util.field_240973_b_).equals(uuid) && this.isPromised();
    }

    default public boolean isMarriedTo(UUID uuid) {
        return this.getPartnerUUID().orElse(Util.field_240973_b_).equals(uuid) && this.isMarried();
    }

    default public boolean isEngagedWith(UUID uuid) {
        return this.getPartnerUUID().orElse(Util.field_240973_b_).equals(uuid) && this.isEngaged();
    }

    public static Optional<EntityRelationship> of(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            return Optional.ofNullable(PlayerSaveData.get(player));
        }
        if (entity instanceof CompassionateEntity) {
            CompassionateEntity compassionateEntity = (CompassionateEntity)entity;
            return Optional.ofNullable(compassionateEntity.getRelationships());
        }
        return Optional.empty();
    }
}

