/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.relationship.family;

import forge.net.mca.MCA;
import forge.net.mca.entity.ai.relationship.EntityRelationship;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.util.NbtHelper;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public final class FamilyTreeNode
implements Serializable {
    private static final long serialVersionUID = -7307057982785253721L;
    private final boolean isPlayer;
    private Gender gender;
    private String name;
    private String profession = Registry.field_218370_L.func_177774_c((Object)VillagerProfession.field_221151_a).toString();
    private final UUID id;
    private UUID father;
    private UUID mother;
    private UUID partner = Util.field_240973_b_;
    private RelationshipState relationshipState = RelationshipState.SINGLE;
    private boolean deceased;
    private final Set<UUID> children = new HashSet<UUID>();
    private final transient FamilyTree rootNode;

    public FamilyTreeNode(FamilyTree rootNode, UUID id, String name, boolean isPlayer, Gender gender, UUID father, UUID mother) {
        this.rootNode = rootNode;
        this.id = id;
        this.name = name;
        this.isPlayer = isPlayer;
        this.gender = gender;
        this.father = father;
        this.mother = mother;
    }

    public FamilyTreeNode(FamilyTree rootNode, UUID id, CompoundNBT nbt) {
        this(rootNode, id, nbt.func_74779_i("name"), nbt.func_74767_n("isPlayer"), Gender.byId(nbt.func_74762_e("gender")), nbt.func_186857_a("father"), nbt.func_186857_a("mother"));
        this.children.addAll(NbtHelper.toList((INBT)nbt.func_150295_c("children", 10), c -> ((CompoundNBT)c).func_186857_a("uuid")));
        this.profession = nbt.func_74779_i("profession");
        this.deceased = nbt.func_74767_n("isDeceased");
        if (nbt.func_186855_b("spouse")) {
            this.partner = nbt.func_186857_a("spouse");
        }
        this.relationshipState = RelationshipState.byId(nbt.func_74762_e("marriageState"));
    }

    public UUID id() {
        return this.id;
    }

    private void markDirty() {
        if (this.rootNode != null) {
            this.rootNode.markDirty();
        }
    }

    public boolean isDeceased() {
        return this.deceased;
    }

    public void setDeceased(boolean deceased) {
        this.deceased = deceased;
        this.markDirty();
    }

    public void setName(String name) {
        this.name = name;
        this.markDirty();
    }

    public String getName() {
        return this.name;
    }

    public void setProfession(VillagerProfession profession) {
        this.profession = Registry.field_218370_L.func_177774_c((Object)profession).toString();
        this.markDirty();
    }

    public VillagerProfession getProfession() {
        return (VillagerProfession)Registry.field_218370_L.func_82594_a(this.getProfessionId());
    }

    public ResourceLocation getProfessionId() {
        return ResourceLocation.func_208304_a((String)this.profession);
    }

    public String getProfessionName() {
        String professionName = (this.getProfessionId().func_110624_b().equalsIgnoreCase("minecraft") ? (this.getProfessionId().func_110623_a().equals("none") ? "mca.none" : this.getProfessionId().func_110623_a()) : this.getProfessionId().toString()).replace(":", ".");
        return MCA.isBlankString(professionName) ? "mca.none" : professionName;
    }

    public IFormattableTextComponent getProfessionText() {
        return new TranslationTextComponent("entity.minecraft.villager." + this.getProfessionName());
    }

    public boolean isPlayer() {
        return this.isPlayer;
    }

    public Gender gender() {
        return this.gender;
    }

    public UUID father() {
        return this.father;
    }

    public UUID mother() {
        return this.mother;
    }

    public UUID partner() {
        return this.partner;
    }

    public RelationshipState getRelationshipState() {
        return this.relationshipState;
    }

    public void setRelationshipState(RelationshipState relationshipState) {
        this.relationshipState = relationshipState;
    }

    public void updatePartner(@Nullable Entity newPartner, @Nullable RelationshipState state) {
        if (!(this.partner.equals(Util.field_240973_b_) || newPartner != null && this.partner.equals(newPartner.func_110124_au()))) {
            this.getRoot().getOrEmpty(this.partner).ifPresent(n -> {
                if (n.relationshipState != RelationshipState.ENGAGED || this.isPlayer) {
                    // empty if block
                }
                n.partner = Util.field_240973_b_;
                n.relationshipState = RelationshipState.SINGLE;
            });
        }
        this.partner = newPartner == null ? Util.field_240973_b_ : newPartner.func_110124_au();
        RelationshipState relationshipState = this.relationshipState = state == null && newPartner == null ? RelationshipState.SINGLE : state;
        if (newPartner != null) {
            this.rootNode.getOrCreate(newPartner);
        }
        this.rootNode.markDirty();
    }

    public void updatePartner(FamilyTreeNode spouse) {
        this.partner = spouse.id();
        this.relationshipState = spouse.isPlayer ? RelationshipState.MARRIED_TO_PLAYER : RelationshipState.MARRIED_TO_VILLAGER;
        this.markDirty();
    }

    public Set<UUID> children() {
        return this.children;
    }

    public Stream<UUID> streamChildren() {
        return this.children.stream().filter(FamilyTreeNode::isValid);
    }

    public Stream<UUID> streamParents() {
        return Stream.of(this.father(), this.mother()).filter(FamilyTreeNode::isValid);
    }

    public Set<UUID> siblings() {
        HashSet<UUID> siblings = new HashSet<UUID>();
        this.streamParents().forEach(parent -> this.getRoot().getOrEmpty((UUID)parent).ifPresent(p -> FamilyTreeNode.gatherChildren(p, siblings, 1)));
        return siblings;
    }

    public Stream<UUID> getChildren() {
        return this.getRelatives(0, 1);
    }

    public Stream<UUID> getAllRelatives(int depth) {
        HashSet family = new HashSet();
        HashSet<UUID> todo = new HashSet<UUID>();
        todo.add(this.id);
        for (int d = 0; d < depth; ++d) {
            HashSet nextTodo = new HashSet();
            for (UUID uuid : todo) {
                if (family.contains(uuid)) continue;
                this.rootNode.getOrEmpty(uuid).ifPresent(node -> {
                    family.add(uuid);
                    node.streamParents().forEach(nextTodo::add);
                    node.streamChildren().forEach(nextTodo::add);
                });
            }
            todo = nextTodo;
        }
        family.remove(this.id);
        return family.stream();
    }

    public Stream<UUID> getRelatives(int parentDepth, int childrenDepth) {
        HashSet<UUID> family = new HashSet<UUID>();
        FamilyTreeNode.gatherParents(this, family, parentDepth);
        FamilyTreeNode.gatherChildren(this, family, childrenDepth);
        family.remove(this.id);
        return family.stream();
    }

    public boolean isRelative(UUID with) {
        return this.getAllRelatives(9).anyMatch(with::equals);
    }

    public Stream<FamilyTreeNode> getParents() {
        return this.lookup(this.streamParents());
    }

    public Stream<FamilyTreeNode> getSiblings() {
        return this.lookup(this.siblings().stream());
    }

    public Stream<FamilyTreeNode> lookup(Stream<UUID> uuids) {
        return uuids.map(this.getRoot()::getOrEmpty).filter(Optional::isPresent).map(Optional::get);
    }

    public boolean isParent(UUID id) {
        return this.streamParents().anyMatch(parent -> parent.equals(id));
    }

    public boolean isGrandParent(UUID id) {
        return this.getParents().anyMatch(parent -> parent.isParent(id));
    }

    public boolean isUncle(UUID id) {
        return this.getParents().flatMap(parent -> parent.siblings().stream()).distinct().anyMatch(id::equals);
    }

    public void addChild(UUID child) {
        this.children.add(child);
    }

    public FamilyTree getRoot() {
        return this.rootNode;
    }

    public boolean assignParents(EntityRelationship one, EntityRelationship two) {
        return this.assignParent(one.getFamilyEntry()) | this.assignParent(two.getFamilyEntry());
    }

    public boolean assignParent(FamilyTreeNode parent) {
        int parents = (FamilyTreeNode.isValid(this.father) ? 1 : 0) + (FamilyTreeNode.isValid(this.mother) ? 1 : 0);
        if (parents == 1) {
            if (!FamilyTreeNode.isValid(this.father)) {
                return this.setFather(parent);
            }
            if (!FamilyTreeNode.isValid(this.mother)) {
                return this.setMother(parent);
            }
        } else {
            if (parent.gender() == Gender.MALE) {
                return this.setFather(parent);
            }
            return this.setMother(parent);
        }
        return true;
    }

    public boolean setFather(FamilyTreeNode parent) {
        this.father = parent.id();
        parent.children().add(this.id);
        this.markDirty();
        return true;
    }

    public boolean setMother(FamilyTreeNode parent) {
        this.mother = parent.id();
        parent.children().add(this.id);
        this.markDirty();
        return true;
    }

    public boolean removeFather() {
        if (FamilyTreeNode.isValid(this.father)) {
            this.rootNode.getOrEmpty(this.father).ifPresent(e -> e.children.remove(this.id));
            this.father = Util.field_240973_b_;
            this.markDirty();
            return true;
        }
        return false;
    }

    public boolean removeMother() {
        if (FamilyTreeNode.isValid(this.mother)) {
            this.rootNode.getOrEmpty(this.mother).ifPresent(e -> e.children.remove(this.id));
            this.mother = Util.field_240973_b_;
            this.markDirty();
            return true;
        }
        return false;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
        this.markDirty();
    }

    public boolean probablyGenerated() {
        return this.mother.equals(Util.field_240973_b_) && this.father.equals(Util.field_240973_b_) && this.children.size() == 1 && this.deceased && !this.isPlayer();
    }

    public boolean willBeRemembered() {
        if (!this.children.isEmpty()) {
            return true;
        }
        if (!this.partner.equals(Util.field_240973_b_)) {
            return true;
        }
        return !this.getParents().allMatch(FamilyTreeNode::probablyGenerated);
    }

    public static boolean isValid(@Nullable UUID uuid) {
        return uuid != null && !Util.field_240973_b_.equals(uuid);
    }

    private static void gatherParents(FamilyTreeNode current, Set<UUID> family, int depth) {
        FamilyTreeNode.gather(current, family, depth, FamilyTreeNode::streamParents);
    }

    private static void gatherChildren(FamilyTreeNode current, Set<UUID> family, int depth) {
        FamilyTreeNode.gather(current, family, depth, FamilyTreeNode::streamChildren);
    }

    private static void gather(@Nullable FamilyTreeNode entry, Set<UUID> output, int depth, Function<FamilyTreeNode, Stream<UUID>> walker) {
        if (entry == null || depth <= 0) {
            return;
        }
        walker.apply(entry).forEach(id -> {
            if (!Util.field_240973_b_.equals(id)) {
                output.add((UUID)id);
            }
            if (depth > 1) {
                entry.getRoot().getOrEmpty((UUID)id).ifPresent(e -> FamilyTreeNode.gather(e, output, depth - 1, walker));
            }
        });
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        nbt.func_74757_a("isPlayer", this.isPlayer);
        nbt.func_74757_a("isDeceased", this.deceased);
        nbt.func_74768_a("gender", this.gender.getId());
        nbt.func_186854_a("father", this.father);
        nbt.func_186854_a("mother", this.mother);
        nbt.func_186854_a("spouse", this.partner);
        nbt.func_74768_a("marriageState", this.relationshipState.ordinal());
        nbt.func_218657_a("children", (INBT)NbtHelper.fromList(this.children, child -> {
            CompoundNBT n = new CompoundNBT();
            n.func_186854_a("uuid", child);
            return n;
        }));
        return nbt;
    }
}

