/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.interaction;

import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.s2c.OpenGuiRequest;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityCommandHandler<T extends Entity> {
    @Nullable
    protected PlayerEntity interactingPlayer;
    protected final T entity;

    public EntityCommandHandler(T entity) {
        this.entity = entity;
    }

    public Optional<PlayerEntity> getInteractingPlayer() {
        return Optional.ofNullable(this.interactingPlayer).filter(player -> player.field_71070_bA != null);
    }

    public void stopInteracting() {
        if (!((Entity)this.entity).field_70170_p.field_72995_K && this.interactingPlayer instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.interactingPlayer;
            serverPlayer.func_71053_j();
        }
        this.interactingPlayer = null;
    }

    public ActionResultType interactAt(PlayerEntity player, Vector3d pos, @NotNull Hand hand) {
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.INTERACT, (Entity)this.entity), serverPlayer);
        }
        this.interactingPlayer = player;
        return ActionResultType.SUCCESS;
    }

    public boolean handle(ServerPlayerEntity player, String command) {
        return false;
    }
}

