/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.interaction;

import forge.net.mca.Config;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.MoveState;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.entity.interaction.EntityCommandHandler;
import forge.net.mca.item.ItemsMCA;
import forge.net.mca.server.world.data.BabyTracker;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.compat.FuzzyPositionsCompat;
import forge.net.mca.util.compat.OptionalCompat;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class VillagerCommandHandler
extends EntityCommandHandler<VillagerEntityMCA> {
    public VillagerCommandHandler(VillagerEntityMCA entity) {
        super(entity);
    }

    @Override
    public boolean handle(ServerPlayerEntity player, String command) {
        Memories memory = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player);
        if (MoveState.byCommand(command).filter(state -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().setMoveState((MoveState)((Object)state), (PlayerEntity)player);
            return true;
        }).isPresent()) {
            return true;
        }
        if (Chore.byCommand(command).filter(chore -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().assignJob((Chore)((Object)chore), (PlayerEntity)player);
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(player, "chores");
            ((VillagerEntityMCA)this.entity).sendChatMessage((IFormattableTextComponent)new TranslationTextComponent("adult.chore.success"), (Entity)player);
            return true;
        }).isPresent()) {
            return true;
        }
        String arg = "";
        String[] split = command.split("\\.");
        if (split.length > 1) {
            command = split[0];
            arg = split[1];
        }
        switch (command) {
            case "pick_up": {
                if (player.func_184188_bt().size() >= 3) {
                    ((Entity)player.func_184188_bt().get(0)).func_184210_p();
                }
                if (((VillagerEntityMCA)this.entity).func_184218_aH()) {
                    ((VillagerEntityMCA)this.entity).func_184210_p();
                } else {
                    ((VillagerEntityMCA)this.entity).func_184205_a((Entity)player, true);
                }
                player.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket((Entity)player));
                return false;
            }
            case "ridehorse": {
                if (((VillagerEntityMCA)this.entity).func_184218_aH()) {
                    ((VillagerEntityMCA)this.entity).func_184210_p();
                } else {
                    OptionalCompat.ifPresentOrElse(((VillagerEntityMCA)this.entity).field_70170_p.func_175674_a((Entity)player, player.func_174813_aQ().func_186662_g(10.0), e -> e instanceof IEquipable && ((IEquipable)e).func_110257_ck()).stream().filter(horse -> !horse.func_184207_aI()).min(Comparator.comparingDouble(a -> a.func_70068_e(this.entity))), horse -> {
                        ((VillagerEntityMCA)this.entity).func_184205_a((Entity)horse, false);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "interaction.ridehorse.success", new Object[0]);
                    }, () -> ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "interaction.ridehorse.fail.notnearby", new Object[0]));
                }
                return true;
            }
            case "sethome": {
                ((VillagerEntityMCA)this.entity).getResidency().setHome((PlayerEntity)player);
                return true;
            }
            case "gohome": {
                ((VillagerEntityMCA)this.entity).getResidency().goHome((PlayerEntity)player);
                this.stopInteracting();
                return false;
            }
            case "setworkplace": {
                ((VillagerEntityMCA)this.entity).getResidency().setWorkplace((PlayerEntity)player);
                return true;
            }
            case "sethangout": {
                ((VillagerEntityMCA)this.entity).getResidency().setHangout((PlayerEntity)player);
                return true;
            }
            case "trade": {
                ((VillagerEntityMCA)this.entity).getInteractions().stopInteracting();
                this.prepareOffersFor((PlayerEntity)player);
                return false;
            }
            case "inventory": {
                player.func_213829_a((INamedContainerProvider)this.entity);
                return false;
            }
            case "gift": {
                ((VillagerEntityMCA)this.entity).getRelationships().giveGift(player, memory);
                return true;
            }
            case "adopt": {
                ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "interaction.adopt.success", new Object[0]);
                FamilyTreeNode parentNode = FamilyTree.get(player.func_71121_q()).getOrCreate((Entity)player);
                ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent(parentNode);
                Optional<FamilyTreeNode> parentSpouse = FamilyTree.get(player.func_71121_q()).getOrEmpty(parentNode.partner());
                parentSpouse.ifPresent(p -> ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)p));
                break;
            }
            case "procreate": {
                BabyTracker tracker = BabyTracker.get((ServerWorld)((VillagerEntityMCA)this.entity).field_70170_p);
                if (tracker.hasActiveBaby(player.func_110124_au(), ((VillagerEntityMCA)this.entity).func_110124_au())) {
                    BabyTracker.Pairing pairing = tracker.getPairing(player.func_110124_au(), ((VillagerEntityMCA)this.entity).func_110124_au());
                    if (((BabyTracker.Placement)((Object)pairing.locateBaby((PlayerEntity)player).getRight())).wasFound()) {
                        ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "interaction.procreate.fail.hasbaby", new Object[0]);
                    } else {
                        ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "interaction.procreate.fail.lostbaby", new Object[0]);
                        pairing.reconstructBaby(player);
                    }
                } else if (memory.getHearts() < 100) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "interaction.procreate.fail.lowhearts", new Object[0]);
                } else {
                    ((VillagerEntityMCA)this.entity).getRelationships().startProcreating();
                }
                return true;
            }
            case "divorcePapers": {
                player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ItemsMCA.DIVORCE_PAPERS.get()));
                return true;
            }
            case "divorceConfirm": {
                ItemStack papers = ((Item)ItemsMCA.DIVORCE_PAPERS.get()).func_190903_i();
                Memories memories = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player);
                if (player.field_71071_by.func_70431_c(papers)) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "divorcePaper", new Object[0]);
                    player.field_71071_by.func_184437_d(papers);
                    memories.modHearts(-20);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "divorce", new Object[0]);
                    memories.modHearts(-200);
                }
                ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue(-5);
                ((VillagerEntityMCA)this.entity).getRelationships().endRelationShip(RelationshipState.SINGLE);
                PlayerSaveData playerData = PlayerSaveData.get(player);
                playerData.endRelationShip(RelationshipState.SINGLE);
                return true;
            }
            case "execute": {
                ((VillagerEntityMCA)this.entity).setProfession((VillagerProfession)ProfessionsMCA.OUTLAW.get());
                return true;
            }
            case "pardon": {
                ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.field_221151_a);
                return true;
            }
            case "stay_in_village": {
                ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.field_221151_a);
                ((VillagerEntityMCA)this.entity).setDespawnDelay(0);
                return true;
            }
            case "hire_short": {
                this.payEmeralds(player, 5);
                ((VillagerEntityMCA)this.entity).makeMercenary(player);
                ((VillagerEntityMCA)this.entity).setDespawnDelay(72000);
                return true;
            }
            case "hire_long": {
                this.payEmeralds(player, 10);
                ((VillagerEntityMCA)this.entity).makeMercenary(player);
                ((VillagerEntityMCA)this.entity).setDespawnDelay(168000);
                return true;
            }
            case "infected": {
                ((VillagerEntityMCA)this.entity).setInfected(!((VillagerEntityMCA)this.entity).isInfected());
                return true;
            }
            case "stopworking": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().abandonJob();
                return true;
            }
            case "armor": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().setArmorWear(!((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear());
                if (((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear()) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "armor.enabled", new Object[0]);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "armor.disabled", new Object[0]);
                }
                return true;
            }
            case "profession": {
                switch (arg) {
                    case "none": {
                        ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.field_221151_a);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "profession.set.none", new Object[0]);
                        break;
                    }
                    case "guard": {
                        ((VillagerEntityMCA)this.entity).setProfession((VillagerProfession)ProfessionsMCA.GUARD.get());
                        ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "profession.set.guard", new Object[0]);
                        break;
                    }
                    case "archer": {
                        ((VillagerEntityMCA)this.entity).setProfession((VillagerProfession)ProfessionsMCA.ARCHER.get());
                        ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "profession.set.archer", new Object[0]);
                    }
                }
                return true;
            }
            case "apologize": {
                Vector3d entityPos = ((VillagerEntityMCA)this.entity).func_213303_ch();
                ((VillagerEntityMCA)this.entity).field_70170_p.func_217357_a(VillagerEntityMCA.class, new AxisAlignedBB(entityPos, entityPos).func_186662_g(32.0)).forEach(v -> {
                    double d = ((VillagerEntityMCA)this.entity).func_70068_e((Entity)v);
                    int n = v.func_70638_az() == null ? 1024 : 64;
                    if (d <= (double)n) {
                        v.pardonPlayers(99);
                    }
                });
                break;
            }
            case "location": {
                if (Config.getInstance().structuresInRumors.size() > 0) {
                    if (arg.length() == 0) {
                        arg = Config.getInstance().structuresInRumors.get(((VillagerEntityMCA)this.entity).func_70681_au().nextInt(Config.getInstance().structuresInRumors.size()));
                    }
                    ResourceLocation identifier = new ResourceLocation(arg);
                    BlockPos pos = FuzzyPositionsCompat.localFuzz(((VillagerEntityMCA)this.entity).func_70681_au(), 1024, 0).func_177971_a((Vector3i)((VillagerEntityMCA)this.entity).func_233580_cy_());
                    Optional<BlockPos> position = WorldUtils.getClosestStructurePosition((ServerWorld)((VillagerEntityMCA)this.entity).field_70170_p, pos, identifier, 64);
                    if (position.isPresent()) {
                        String posString = position.get().func_177958_n() + "," + position.get().func_177956_o() + "," + position.get().func_177952_p();
                        ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "dialogue.location." + identifier.func_110623_a(), new Object[]{posString});
                        break;
                    }
                    ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "dialogue.location.forgot", new Object[0]);
                    break;
                }
                ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "dialogue.location.forgot", new Object[0]);
                break;
            }
            case "slap": {
                player.func_70097_a(DamageSource.field_191291_g, 1.0f);
            }
        }
        return super.handle(player, command);
    }

    private void payEmeralds(ServerPlayerEntity player, int emeralds) {
        PlayerInventory inventory = player.field_71071_by;
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack itemStack = inventory.func_70301_a(j);
            if (!itemStack.func_77973_b().equals(Items.field_151166_bC)) continue;
            int c = Math.min(itemStack.func_190916_E(), emeralds);
            itemStack.func_190918_g(c);
            if ((emeralds -= c) > 0) continue;
            return;
        }
    }

    public void prepareOffersFor(PlayerEntity player) {
        EffectInstance effectInstance;
        int i = ((VillagerEntityMCA)this.entity).func_223107_f(player);
        if (i != 0) {
            for (MerchantOffer tradeOffer : ((VillagerEntityMCA)this.entity).func_213706_dY()) {
                tradeOffer.func_222207_a(-MathHelper.func_76141_d((float)((float)i * tradeOffer.func_222211_m())));
            }
        }
        if (player.func_70644_a(Effects.field_220310_F) && (effectInstance = player.func_70660_b(Effects.field_220310_F)) != null) {
            int k = effectInstance.func_76458_c();
            for (MerchantOffer merchantOffer : ((VillagerEntityMCA)this.entity).func_213706_dY()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantOffer.func_222218_a().func_190916_E());
                merchantOffer.func_222207_a(-Math.max(j, 1));
            }
        }
        ((VillagerEntityMCA)this.entity).func_70932_a_(player);
        ((VillagerEntityMCA)this.entity).func_213707_a(player, ((VillagerEntityMCA)this.entity).func_145748_c_(), ((VillagerEntityMCA)this.entity).func_213700_eh().func_221132_c());
    }
}

