/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.interaction.gifts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import forge.net.mca.client.gui.Constraint;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.LongTermMemory;
import forge.net.mca.entity.ai.MoodGroup;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.Personality;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.Tasks;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import me.shedaniel.architectury.hooks.TagHooks;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.Nullable;

public class GiftPredicate {
    public static final Map<String, Factory<JsonElement>> CONDITION_TYPES = new HashMap<String, Factory<JsonElement>>();
    private final int satisfactionBoost;
    @Nullable
    private final Condition condition;
    List<String> conditionKeys;

    public static float divideAndAdd(JsonObject json, long value) {
        return MathHelper.func_76131_a((float)((float)value / (json.has("dividend") ? json.get("dividend").getAsFloat() : 1.0f) + (json.has("add") ? json.get("add").getAsFloat() : 0.0f)), (float)0.0f, (float)(json.has("max") ? json.get("max").getAsFloat() : 1.0f));
    }

    public static <T> void register(String name, BiFunction<JsonElement, String, T> jsonParser, Factory<T> predicate) {
        CONDITION_TYPES.put(name, json -> predicate.parse(jsonParser.apply((JsonElement)json, name)));
    }

    public static GiftPredicate fromJson(JsonObject json) {
        int satisfaction = 0;
        @Nullable Condition condition = null;
        LinkedList<String> conditionKeys = new LinkedList<String>();
        for (Map.Entry entry : json.entrySet()) {
            if ("satisfaction_boost".equals(entry.getKey())) {
                satisfaction = JSONUtils.func_151215_f((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                continue;
            }
            if (!CONDITION_TYPES.containsKey(entry.getKey())) continue;
            Condition parsed = CONDITION_TYPES.get(entry.getKey()).parse((JsonElement)entry.getValue());
            conditionKeys.add((String)entry.getKey());
            if (condition == null) {
                condition = parsed;
                continue;
            }
            condition = condition.and(parsed);
        }
        return new GiftPredicate(satisfaction, condition, conditionKeys);
    }

    public GiftPredicate(int satisfactionBoost, @Nullable Condition condition, List<String> conditionKeys) {
        this.satisfactionBoost = satisfactionBoost;
        this.condition = condition;
        this.conditionKeys = conditionKeys;
    }

    public float test(VillagerEntityMCA recipient, ItemStack stack, @Nullable ServerPlayerEntity player) {
        return this.condition != null ? this.condition.test(recipient, stack, player) : 0.0f;
    }

    public int getSatisfactionFor(VillagerEntityMCA recipient, ItemStack stack, @Nullable ServerPlayerEntity player) {
        return (int)(this.test(recipient, stack, player) * (float)this.satisfactionBoost);
    }

    public List<String> getConditionKeys() {
        return this.conditionKeys;
    }

    static {
        GiftPredicate.register("profession", (json, name) -> new ResourceLocation(JSONUtils.func_151206_a((JsonElement)json, (String)name)), profession -> (villager, stack, player) -> Registry.field_218370_L.func_177774_c((Object)villager.getProfession()).equals(profession) ? 1.0f : 0.0f);
        GiftPredicate.register("age_group", (json, name) -> AgeState.valueOf(JSONUtils.func_151206_a((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), group -> (villager, stack, player) -> villager.getAgeState() == group ? 1.0f : 0.0f);
        GiftPredicate.register("gender", (json, name) -> Gender.valueOf(JSONUtils.func_151206_a((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), gender -> (villager, stack, player) -> villager.getGenetics().getGender() == gender ? 1.0f : 0.0f);
        GiftPredicate.register("has_item", (json, name) -> Ingredient.func_199802_a((JsonElement)json), item -> (villager, stack, player) -> {
            for (int i = 0; i < villager.func_213715_ed().func_70302_i_(); ++i) {
                if (!item.test(villager.func_213715_ed().func_70301_a(i))) continue;
                return 1.0f;
            }
            return 0.0f;
        });
        GiftPredicate.register("min_health", JSONUtils::func_151220_d, health -> (villager, stack, player) -> villager.func_110143_aJ() > health.floatValue() ? 1.0f : 0.0f);
        GiftPredicate.register("is_married", JSONUtils::func_151216_b, married -> (villager, stack, player) -> villager.getRelationships().isMarried() == married.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("has_home", JSONUtils::func_151216_b, hasHome -> (villager, stack, player) -> villager.getResidency().getHome().isPresent() == hasHome.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("has_village", JSONUtils::func_151216_b, hasVillage -> (villager, stack, player) -> villager.getResidency().getHomeVillage().isPresent() == hasVillage.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("min_infection_progress", JSONUtils::func_151220_d, progress -> (villager, stack, player) -> villager.getInfectionProgress() > progress.floatValue() ? 1.0f : 0.0f);
        GiftPredicate.register("mood", (json, name) -> JSONUtils.func_151206_a((JsonElement)json, (String)name).toLowerCase(Locale.ENGLISH), mood -> (villager, stack, player) -> villager.getVillagerBrain().getMood().getName().equals(mood) ? 1.0f : 0.0f);
        GiftPredicate.register("mood_group", (json, name) -> MoodGroup.valueOf(JSONUtils.func_151206_a((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), moodGroup -> (villager, stack, player) -> villager.getVillagerBrain().getPersonality().getMoodGroup() == moodGroup ? 1.0f : 0.0f);
        GiftPredicate.register("personality", (json, name) -> Personality.valueOf(JSONUtils.func_151206_a((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), personality -> (villager, stack, player) -> villager.getVillagerBrain().getPersonality() == personality ? 1.0f : 0.0f);
        GiftPredicate.register("is_pregnant", JSONUtils::func_151216_b, pregnant -> (villager, stack, player) -> villager.getRelationships().getPregnancy().isPregnant() == pregnant.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("min_pregnancy_progress", JSONUtils::func_151215_f, progress -> (villager, stack, player) -> villager.getRelationships().getPregnancy().getBabyAge() > progress ? 1.0f : 0.0f);
        GiftPredicate.register("pregnancy_child_gender", (json, name) -> Gender.valueOf(JSONUtils.func_151206_a((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), gender -> (villager, stack, player) -> villager.getRelationships().getPregnancy().getGender() == gender ? 1.0f : 0.0f);
        GiftPredicate.register("current_chore", (json, name) -> Chore.valueOf(JSONUtils.func_151206_a((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), chore -> (villager, stack, player) -> villager.getVillagerBrain().getCurrentJob() == chore ? 1.0f : 0.0f);
        GiftPredicate.register("item", (json, name) -> {
            ResourceLocation id = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)json, (String)name));
            Item item = (Item)Registry.field_212630_s.func_241873_b(id).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + id + "'"));
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)});
        }, ingredient -> (villager, stack, player) -> ingredient.test(stack) ? 1.0f : 0.0f);
        GiftPredicate.register("tag", (json, name) -> {
            ResourceLocation id = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)json, (String)name));
            ITag.INamedTag tag = TagHooks.getItemOptional((ResourceLocation)id);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + id + "'");
            }
            return Ingredient.func_199805_a((ITag)tag);
        }, ingredient -> (villager, stack, player) -> ingredient.test(stack) ? 1.0f : 0.0f);
        GiftPredicate.register("trait", (json, name) -> Traits.Trait.valueOf(JSONUtils.func_151206_a((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), trait -> (villager, stack, player) -> villager.getTraits().hasTrait((Traits.Trait)((Object)trait)) ? 1.0f : 0.0f);
        GiftPredicate.register("hearts_min", JSONUtils::func_151215_f, hearts -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player).getHearts();
            return h >= hearts ? 1.0f : 0.0f;
        });
        GiftPredicate.register("hearts_max", JSONUtils::func_151215_f, hearts -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player).getHearts();
            return h <= hearts ? 1.0f : 0.0f;
        });
        GiftPredicate.register("hearts", JSONUtils::func_151210_l, json -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player).getHearts();
            return GiftPredicate.divideAndAdd(json, h);
        });
        GiftPredicate.register("memory", JSONUtils::func_151210_l, json -> (villager, stack, player) -> {
            String id = LongTermMemory.parseId(json, player);
            long ticks = villager.getLongTermMemory().getMemory(id);
            return GiftPredicate.divideAndAdd(json, ticks);
        });
        GiftPredicate.register("emeralds", JSONUtils::func_151215_f, amount -> (villager, stack, player) -> player != null && player.field_71071_by.func_213901_a(Items.field_151166_bC) >= amount ? 1.0f : 0.0f);
        GiftPredicate.register("village_has_building", JSONUtils::func_151206_a, name -> (villager, stack, player) -> villager.getResidency().getHomeVillage().filter(v -> v.hasBuilding((String)name)).isPresent() ? 1.0f : 0.0f);
        GiftPredicate.register("rank", JSONUtils::func_151206_a, name -> (villager, stack, player) -> villager.getResidency().getHomeVillage().filter(v -> Tasks.getRank(v, player) == Rank.fromName(name)).isPresent() ? 1.0f : 0.0f);
        GiftPredicate.register("time_min", JSONUtils::func_219794_f, time -> (villager, stack, player) -> villager.field_70170_p.func_72820_D() % 24000L >= time ? 1.0f : 0.0f);
        GiftPredicate.register("time_max", JSONUtils::func_219794_f, time -> (villager, stack, player) -> villager.field_70170_p.func_72820_D() % 24000L <= time ? 1.0f : 0.0f);
        GiftPredicate.register("biome", (json, name) -> new ResourceLocation(JSONUtils.func_151206_a((JsonElement)json, (String)name)), biome -> (villager, stack, player) -> {
            Optional biomeKey = villager.field_70170_p.func_242406_i(villager.func_233580_cy_());
            return biomeKey.filter(b -> b.func_240901_a_().equals(biome)).map(result -> Float.valueOf(1.0f)).orElse(Float.valueOf(0.0f)).floatValue();
        });
        GiftPredicate.register("advancement", (json, name) -> new ResourceLocation(JSONUtils.func_151206_a((JsonElement)json, (String)name)), id -> (villager, stack, player) -> {
            assert (player != null);
            Advancement advancement = Objects.requireNonNull(player.func_184102_h()).func_191949_aK().func_192778_a(id);
            return player.func_192039_O().func_192747_a(advancement).func_192105_a() ? 1.0f : 0.0f;
        });
        GiftPredicate.register("constraints", (json, name) -> Constraint.fromStringList(JSONUtils.func_151206_a((JsonElement)json, (String)name)), constraints -> (villager, stack, player) -> {
            Set<Constraint> c = Constraint.allMatching(villager, player);
            return c.containsAll((Collection<?>)constraints) ? 1.0f : 0.0f;
        });
    }

    public static interface Factory<T> {
        public Condition parse(T var1);
    }

    public static interface Condition {
        public float test(VillagerEntityMCA var1, ItemStack var2, @Nullable ServerPlayerEntity var3);

        default public Condition and(Condition b) {
            Condition a = this;
            return (villager, stack, player) -> a.test(villager, stack, player) * b.test(villager, stack, player);
        }
    }
}

