/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.interaction.gifts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.interaction.gifts.GiftPredicate;
import forge.net.mca.entity.interaction.gifts.Response;
import forge.net.mca.resources.data.analysis.IntAnalysis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.architectury.hooks.TagHooks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class GiftType {
    static final List<GiftType> REGISTRY = new ArrayList<GiftType>();
    private final ResourceLocation id;
    private int priority;
    private final List<GiftPredicate> conditions;
    private final Map<Item, Integer> items;
    private final Map<ITag.INamedTag<Item>, Integer> tags;
    private int fail;
    private int good;
    private int better;
    private final Map<Response, String> responses;

    public static GiftType fromJson(ResourceLocation id, JsonObject json) {
        ArrayList<GiftPredicate> conditions = new ArrayList<GiftPredicate>();
        JSONUtils.func_151213_a((JsonObject)json, (String)"conditions", (JsonArray)new JsonArray()).forEach(element -> conditions.add(GiftPredicate.fromJson(JSONUtils.func_151210_l((JsonElement)element, (String)"condition"))));
        HashMap<Item, Integer> items = new HashMap<Item, Integer>();
        HashMap<ITag.INamedTag<Item>, Integer> tags = new HashMap<ITag.INamedTag<Item>, Integer>();
        JSONUtils.func_152754_s((JsonObject)json, (String)"items").entrySet().forEach(element -> {
            String string = (String)element.getKey();
            Integer satisfaction = ((JsonElement)element.getValue()).getAsInt();
            if (string.charAt(0) == '#') {
                ResourceLocation identifier = new ResourceLocation(string.substring(1));
                ITag.INamedTag tag = TagHooks.getItemOptional((ResourceLocation)identifier);
                if (tag != null) {
                    tags.put(tag, satisfaction);
                } else if (identifier.func_110624_b().equals("mca")) {
                    throw new JsonSyntaxException("Unknown item tag '" + identifier + "'");
                }
            } else {
                ResourceLocation identifier = new ResourceLocation(string);
                Optional item = Registry.field_212630_s.func_241873_b(identifier);
                if (item.isPresent()) {
                    items.put((Item)item.get(), satisfaction);
                } else if (identifier.func_110624_b().equals("mca")) {
                    throw new JsonSyntaxException("Unknown item '" + identifier + "'");
                }
            }
        });
        int priority = JSONUtils.func_151208_a((JsonObject)json, (String)"priority", (int)0);
        JsonObject thresholds = JSONUtils.func_151218_a((JsonObject)json, (String)"thresholds", (JsonObject)new JsonObject());
        int fail = JSONUtils.func_151208_a((JsonObject)thresholds, (String)"fail", (int)0);
        int good = JSONUtils.func_151208_a((JsonObject)thresholds, (String)"good", (int)10);
        int better = JSONUtils.func_151208_a((JsonObject)thresholds, (String)"better", (int)20);
        JsonObject responsesJson = JSONUtils.func_151218_a((JsonObject)json, (String)"responses", (JsonObject)new JsonObject());
        Map<Response, String> responses = Stream.of(Response.values()).collect(Collectors.toMap(Function.identity(), response -> JSONUtils.func_151219_a((JsonObject)responsesJson, (String)response.name().toLowerCase(Locale.ENGLISH), (String)response.getDefaultDialogue())));
        return new GiftType(id, priority, conditions, items, tags, fail, good, better, responses);
    }

    public static Stream<GiftType> allMatching(ItemStack stack) {
        return REGISTRY.stream().filter(type -> type.matches(stack));
    }

    public static Optional<GiftType> bestMatching(VillagerEntityMCA recipient, ItemStack stack, ServerPlayerEntity player) {
        int max = GiftType.allMatching(stack).mapToInt(a -> a.priority).max().orElse(0);
        Optional<GiftType> worst = GiftType.allMatching(stack).filter(a -> a.priority == max).filter(a -> a.getResponse(a.getSatisfactionFor(recipient, stack, player).getTotal()) == Response.FAIL).max(Comparator.comparingDouble(a -> a.getSatisfactionFor(recipient, stack, player).getTotal().intValue()));
        if (worst.isPresent()) {
            return worst;
        }
        return GiftType.allMatching(stack).filter(a -> a.priority == max).max(Comparator.comparingDouble(a -> a.getSatisfactionFor(recipient, stack, player).getTotal().intValue()));
    }

    public static Optional<GiftType> getGiftType(ResourceLocation id) {
        return REGISTRY.stream().filter(p -> p.id.equals((Object)id)).findFirst();
    }

    private static Map<Response, String> getDefaultDialogues() {
        return Arrays.stream(Response.values()).collect(Collectors.toMap(r -> r, Response::getDefaultDialogue));
    }

    public GiftType(Item item, int satisfaction, ResourceLocation extendFrom) {
        this(item, satisfaction, GiftType.getDefaultDialogues());
        Optional<GiftType> type = GiftType.getGiftType(extendFrom);
        type.ifPresent(this::extendFrom);
    }

    public GiftType(Item item, int satisfaction, Map<Response, String> responses) {
        this(Registry.field_212630_s.func_177774_c((Object)item), 0, new LinkedList<GiftPredicate>(), Collections.singletonMap(item, satisfaction), Collections.emptyMap(), 0, 10, 20, responses);
    }

    public GiftType(ResourceLocation id, int priority, List<GiftPredicate> conditions, Map<Item, Integer> items, Map<ITag.INamedTag<Item>, Integer> tags, int fail, int good, int better, Map<Response, String> responses) {
        this.id = id;
        this.priority = priority;
        this.conditions = conditions;
        this.items = items;
        this.tags = tags;
        this.fail = fail;
        this.good = good;
        this.better = better;
        this.responses = responses;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<GiftPredicate> getConditions() {
        return this.conditions;
    }

    public Map<Response, String> getResponses() {
        return this.responses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(ItemStack stack) {
        if (this.items.keySet().stream().anyMatch(i -> i == stack.func_77973_b())) return true;
        if (!this.tags.keySet().stream().anyMatch(arg_0 -> ((Item)stack.func_77973_b()).func_206844_a(arg_0))) return false;
        return true;
    }

    public IntAnalysis getSatisfactionFor(VillagerEntityMCA recipient, ItemStack stack, ServerPlayerEntity player) {
        IntAnalysis analysis = new IntAnalysis();
        Optional<Integer> value = this.items.entrySet().stream().filter(i -> i.getKey() == stack.func_77973_b()).findFirst().map(Map.Entry::getValue);
        int base = value.orElseGet(() -> this.tags.entrySet().stream().filter(i -> stack.func_77973_b().func_206844_a((ITag)i.getKey())).findFirst().map(Map.Entry::getValue).orElse(0));
        analysis.add("base", base);
        for (GiftPredicate c : this.conditions) {
            int val = c.getSatisfactionFor(recipient, stack, player);
            if (!(c.test(recipient, stack, player) > 0.0f)) continue;
            analysis.add(c.getConditionKeys().get(0), val);
        }
        return analysis;
    }

    public Response getResponse(int satisfaction) {
        return satisfaction <= this.fail ? Response.FAIL : (satisfaction <= this.good ? Response.GOOD : (satisfaction <= this.better ? Response.BETTER : Response.BEST));
    }

    public String getDialogueFor(Response response) {
        return this.responses.get((Object)response);
    }

    public void extendFrom(GiftType extendingType) {
        this.conditions.addAll(extendingType.getConditions());
        this.responses.clear();
        this.responses.putAll(extendingType.getResponses());
        this.priority = extendingType.priority;
        this.fail = extendingType.fail;
        this.good = extendingType.good;
        this.better = extendingType.better;
    }
}

