/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.forge;

import com.mojang.brigadier.CommandDispatcher;
import forge.net.mca.MCAClient;
import forge.net.mca.server.ServerInteractionManager;
import forge.net.mca.server.command.AdminCommand;
import forge.net.mca.server.command.Command;
import forge.net.mca.server.world.data.VillageManager;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mca")
public class ForgeBusEvents {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        AdminCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        Command.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            VillageManager.get((ServerWorld)event.world).tick();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            ServerInteractionManager.getInstance().tick();
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            VillageManager.get((ServerWorld)event.getEntity().field_70170_p).getBabies().pop(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void OnEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && (Minecraft.func_71410_x().field_71439_g == null || event.getEntity().func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au()))) {
            MCAClient.onLogin();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        ServerInteractionManager.getInstance().onPlayerJoin((ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onParticleFactoryRegistration(TickEvent.ClientTickEvent event) {
        MCAClient.tickClient(Minecraft.func_71410_x());
    }
}

