/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import forge.net.mca.ClientProxy;
import forge.net.mca.Config;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerFactory;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.network.c2s.GetChildDataRequest;
import forge.net.mca.network.s2c.OpenGuiRequest;
import forge.net.mca.server.world.data.BabyTracker;
import forge.net.mca.util.WorldUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class BabyItem
extends Item {
    public static final LoadingCache<UUID, Optional<BabyTracker.ChildSaveState>> CLIENT_STATE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(CacheLoader.from(id -> {
        NetworkHandler.sendToServer(new GetChildDataRequest((UUID)id));
        return Optional.empty();
    }));
    private final Gender gender;

    public BabyItem(Gender gender, Item.Properties properties) {
        super(properties);
        this.gender = gender;
    }

    public Gender getGender() {
        return this.gender;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public boolean onDropped(ItemStack stack, PlayerEntity player) {
        if (!BabyItem.hasBeenInvalidated(stack)) {
            if (!player.field_70170_p.field_72995_K) {
                int count = 0;
                if (stack.func_196082_o().func_150297_b("dropAttempts", 3)) {
                    count = stack.func_196082_o().func_74762_e("dropAttempts") + 1;
                }
                stack.func_196082_o().func_74768_a("dropAttempts", count);
                CriterionMCA.BABY_DROPPED_CRITERION.trigger((ServerPlayerEntity)player, count);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.mca.baby.no_drop"), true);
            }
            return false;
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (world.func_82737_E() % 20L == 0L) {
                HashSet found = new HashSet();
                int i = player.field_71071_by.func_70302_i_() - 1;
                while (i >= 0) {
                    ItemStack s = player.field_71071_by.func_70301_a(i);
                    int sl = i--;
                    BabyTracker.getStateId(s).ifPresent(id -> {
                        if (found.contains(id)) {
                            player.field_71071_by.func_70304_b(sl);
                        } else {
                            found.add(id);
                        }
                    });
                }
            }
        }
        if (BabyTracker.hasState(stack)) {
            Optional<BabyTracker.MutableChildSaveState> state2 = BabyTracker.getState(stack, (ServerWorld)world);
            if (state2.isPresent()) {
                if (stack.func_82837_s()) {
                    state2.get().setName(stack.func_200301_q().getString());
                    state2.get().writeToItem(stack);
                    stack.func_135074_t();
                    if (entity instanceof ServerPlayerEntity) {
                        ServerPlayerEntity player = (ServerPlayerEntity)entity;
                        CriterionMCA.GENERIC_EVENT_CRITERION.trigger(player, "rename_baby");
                    }
                }
                if (state2.get().getName().isPresent() && world.func_82737_E() % 1200L == 0L) {
                    stack.func_77978_p().func_74768_a("age", stack.func_77978_p().func_74762_e("age") + 1200);
                }
            } else {
                BabyTracker.invalidate(stack);
            }
        } else if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("invalidated")) {
            BabyTracker.get((ServerWorld)world).getPairing(entity.func_110124_au(), entity.func_110124_au()).addChild(state -> {
                state.setGender(this.gender);
                state.setOwner(entity);
                state.writeToItem(stack);
            });
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return BabyItem.getClientCheckedState(stack).flatMap(BabyTracker.ChildSaveState::getName).map(s -> new TranslationTextComponent(this.func_77667_c(stack) + ".named", new Object[]{s})).orElseGet(() -> super.func_200295_i(stack));
    }

    public String func_77667_c(ItemStack stack) {
        if (BabyItem.hasBeenInvalidated(stack)) {
            return super.func_77667_c(stack) + ".blanket";
        }
        return super.func_77667_c(stack);
    }

    public final ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        return BabyTracker.getState(stack, (ServerWorld)world).map(state -> {
            if (!state.getName().isPresent()) {
                if (player instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                    NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.BABY_NAME), serverPlayer);
                }
                return ActionResult.func_226250_c_((Object)stack);
            }
            if (!BabyItem.isReadyToGrowUp(stack)) {
                return ActionResult.func_226250_c_((Object)stack);
            }
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                this.birthChild((BabyTracker.ChildSaveState)state, (ServerWorld)world, serverPlayer);
            }
            stack.func_190918_g(1);
            return ActionResult.func_226248_a_((Object)stack);
        }).orElseGet(() -> {
            if (BabyTracker.getState(stack).isPresent()) {
                world.func_72960_a((Entity)player, (byte)43);
                player.func_184185_a(SoundEvents.field_194227_ie, 1.0f, 1.0f);
                BabyTracker.invalidate(stack);
                return ActionResult.func_226251_d_((Object)stack);
            }
            return ActionResult.func_226251_d_((Object)stack);
        });
    }

    protected VillagerEntityMCA birthChild(BabyTracker.ChildSaveState state, ServerWorld world, ServerPlayerEntity player) {
        VillagerEntityMCA child = VillagerFactory.newVillager((World)world).withName(state.getName().orElse("Unnamed")).withPosition(player.func_213303_ch()).withGender(this.gender).withAge(-AgeState.getMaxAge()).build();
        List parents = state.getParents().map(arg_0 -> ((ServerWorld)world).func_217461_a(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        Optional mother = parents.stream().findFirst();
        Optional father = parents.stream().skip(1L).findFirst();
        child.getGenetics().combine(mother.map(VillagerLike::toVillager).map(VillagerLike::getGenetics), father.map(VillagerLike::toVillager).map(VillagerLike::getGenetics), state.getSeed());
        mother.map(VillagerLike::toVillager).map(VillagerLike::getTraits).ifPresent(t -> child.getTraits().inherit((Traits)t, state.getSeed()));
        father.map(VillagerLike::toVillager).map(VillagerLike::getTraits).ifPresent(t -> child.getTraits().inherit((Traits)t, state.getSeed()));
        state.getParents().forEach(p -> FamilyTree.get(world).getOrEmpty((UUID)p).ifPresent(parent -> child.getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)parent)));
        WorldUtils.spawnEntity((World)world, (MobEntity)child, SpawnReason.BREEDING);
        Stream.concat(Stream.of(mother, father).filter(Optional::isPresent).map(Optional::get), Stream.of(player)).filter(e -> e instanceof ServerPlayerEntity).map(ServerPlayerEntity.class::cast).distinct().forEach(ply -> {
            CriterionMCA.FAMILY.trigger((ServerPlayerEntity)ply);
            Memories memories = child.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)ply);
            memories.setHearts(Config.getInstance().childInitialHearts);
        });
        BabyTracker.get(world).getPairing(state).removeChild(state);
        return child;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        BabyItem.getClientState(stack).ifPresent(state -> {
            PlayerEntity player = ClientProxy.getClientPlayer();
            CompoundNBT nbt = stack.func_77978_p();
            assert (nbt != null);
            int age = nbt.func_74762_e("age") + (int)(world == null ? 0L : world.func_82737_E() % 1200L);
            if (!state.getName().isPresent()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mca.baby.give_name").func_240699_a_(TextFormatting.YELLOW));
            } else {
                StringTextComponent text = new StringTextComponent(state.getName().get());
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mca.baby.name", new Object[]{text.func_230530_a_(text.func_150256_b().func_240718_a_(Color.func_240743_a_((int)this.gender.getColor())))}).func_240699_a_(TextFormatting.GRAY));
                if (age > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("item.mca.baby.age", new Object[]{StringUtils.func_76337_a((int)age)}).func_240699_a_(TextFormatting.GRAY));
                }
            }
            tooltip.add(StringTextComponent.field_240750_d_);
            state.getOwner().ifPresent(owner -> tooltip.add((ITextComponent)new TranslationTextComponent("item.mca.baby.owner", new Object[]{player != null && ((UUID)owner.getLeft()).equals(player.func_110124_au()) ? new TranslationTextComponent("item.mca.baby.owner.you") : owner.getRight()}).func_240699_a_(TextFormatting.GRAY)));
            if (state.getName().isPresent() && BabyItem.canGrow(age)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mca.baby.state.ready").func_240699_a_(TextFormatting.DARK_GREEN));
            }
            if (state.isInfected()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mca.baby.state.infected").func_240699_a_(TextFormatting.DARK_GREEN));
            }
        });
    }

    private static Optional<BabyTracker.ChildSaveState> getClientCheckedState(ItemStack stack) {
        return BabyTracker.getState(stack).map(state -> {
            Optional loaded = (Optional)CLIENT_STATE_CACHE.getIfPresent((Object)state.getId());
            if (loaded == null) {
                return state;
            }
            if (loaded.isPresent()) {
                BabyTracker.ChildSaveState l = (BabyTracker.ChildSaveState)loaded.get();
                if (state.getName().isPresent() && !l.getName().isPresent() || state.getName().isPresent() && l.getName().isPresent() && !state.getName().get().contentEquals(l.getName().get())) {
                    CLIENT_STATE_CACHE.refresh((Object)state.getId());
                    return state;
                }
                return l;
            }
            return state;
        });
    }

    private static Optional<BabyTracker.ChildSaveState> getClientState(ItemStack stack) {
        return BabyTracker.getState(stack).flatMap(state -> {
            try {
                return (Optional)CLIENT_STATE_CACHE.get((Object)state.getId());
            }
            catch (ExecutionException e) {
                return Optional.of(state);
            }
        });
    }

    public static boolean hasBeenInvalidated(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("invalidated") || BabyTracker.getStateId(stack).map(id -> {
            Optional loaded = (Optional)CLIENT_STATE_CACHE.getIfPresent(id);
            return loaded != null && !loaded.isPresent();
        }).orElse(false) != false;
    }

    private static boolean canGrow(int age) {
        return age >= Config.getInstance().babyItemGrowUpTime;
    }

    private static boolean isReadyToGrowUp(ItemStack stack) {
        return stack.func_77942_o() && BabyItem.canGrow(stack.func_77978_p().func_74762_e("age"));
    }
}

