/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.item;

import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Relationship;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.item.SpecialCaseGift;
import forge.net.mca.item.TooltippedItem;
import forge.net.mca.server.world.data.PlayerSaveData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;

public abstract class RelationshipItem
extends TooltippedItem
implements SpecialCaseGift {
    public RelationshipItem(Item.Properties properties) {
        super(properties);
    }

    abstract float getHeartsRequired();

    @Override
    public boolean handle(ServerPlayerEntity player, VillagerEntityMCA villager) {
        String response;
        PlayerSaveData playerData = PlayerSaveData.get(player);
        Memories memory = villager.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)player);
        if (villager.func_70631_g_()) {
            response = "interaction.relationship.fail.isbaby";
        } else if (Relationship.IS_PARENT.test((CompassionateEntity<?>)villager, (Entity)player)) {
            response = "interaction.relationship.fail.isparent";
        } else if (Relationship.IS_MARRIED.test((CompassionateEntity<?>)villager, (Entity)player)) {
            response = "interaction.relationship.fail.marriedtogiver";
        } else if (villager.getRelationships().isMarried()) {
            response = "interaction.relationship.fail.married";
        } else if (villager.getRelationships().isEngaged() && !Relationship.IS_ENGAGED.test((CompassionateEntity<?>)villager, (Entity)player)) {
            response = "interaction.relationship.fail.engaged";
        } else if (playerData.isMarried()) {
            response = "interaction.relationship.fail.playermarried";
        } else if ((float)memory.getHearts() < this.getHeartsRequired()) {
            response = "interaction.relationship.fail.lowhearts";
        } else if (!villager.canBeAttractedTo(playerData)) {
            response = "interaction.relationship.fail.incompatible";
        } else {
            return false;
        }
        villager.sendChatMessage((PlayerEntity)player, response, new Object[0]);
        return true;
    }
}

