/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.item;

import forge.net.mca.SoundsMCA;
import forge.net.mca.TagsMCA;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.block.TombstoneBlock;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.util.localization.FlowingText;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SwordItem;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class ScytheItem
extends SwordItem {
    public ScytheItem(Item.Properties settings) {
        super((IItemTier)ItemTier.GOLD, 10, -2.4f, settings);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        tooltip.addAll(FlowingText.wrap((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".tooltip").func_240699_a_(TextFormatting.GRAY), 160));
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        boolean active = stack.func_196082_o().func_74767_n("active");
        Random r = entity.field_70170_p.field_73012_v;
        if (active != selected) {
            stack.func_196082_o().func_74757_a("active", selected);
            float baseVolume = selected ? 0.75f : 0.25f;
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)SoundsMCA.REAPER_SCYTHE_OUT.get(), entity.func_184176_by(), baseVolume + r.nextFloat() / 2.0f, 0.65f + r.nextFloat() / 10.0f);
        }
        if (selected && living.field_110158_av == -1) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)SoundsMCA.REAPER_SCYTHE_SWING.get(), entity.func_184176_by(), 0.25f, 1.0f);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity user, Hand hand) {
        user.func_184598_c(hand);
        return super.func_77659_a(world, user, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (ScytheItem.hasSoul(context.func_195996_i())) {
            ActionResultType result = ScytheItem.use(context, false);
            if (result == ActionResultType.SUCCESS) {
                ScytheItem.setSoul(context.func_195996_i(), false);
            }
            if (result != ActionResultType.PASS) {
                return result;
            }
        }
        return super.func_195939_a(context);
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || ScytheItem.hasSoul(stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.field_70170_p.field_73012_v.nextInt(50) > 40) {
            target.func_195064_c(new EffectInstance(Effects.field_82731_v, 1000, 1));
        }
        SoundEvent sound = (SoundEvent)SoundsMCA.REAPER_SCYTHE_OUT.get();
        if (!ScytheItem.hasSoul(stack) && target.func_233643_dh_() && (target.func_200600_R() == EntitiesMCA.MALE_VILLAGER.get() || target.func_200600_R() == EntitiesMCA.FEMALE_VILLAGER.get())) {
            ScytheItem.setSoul(stack, true);
            sound = SoundEvents.field_219604_Z;
            if (attacker instanceof ServerPlayerEntity) {
                CriterionMCA.GENERIC_EVENT_CRITERION.trigger((ServerPlayerEntity)attacker, "scytheKill");
            }
        }
        Random r = attacker.field_70170_p.field_73012_v;
        attacker.field_70170_p.func_184133_a(null, attacker.func_233580_cy_(), sound, attacker.func_184176_by(), 0.75f + r.nextFloat() / 2.0f, 0.75f + r.nextFloat() / 2.0f);
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean func_82789_a(ItemStack stack, ItemStack ingredient) {
        return stack.func_77973_b() == ingredient.func_77973_b();
    }

    public static void setSoul(ItemStack stack, boolean soul) {
        stack.func_196082_o().func_74757_a("hasSoul", soul);
    }

    public static boolean hasSoul(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("hasSoul");
    }

    public static ActionResultType use(ItemUseContext context, boolean cure) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos = context.func_195995_a());
        if (state.func_235714_a_(TagsMCA.Blocks.TOMBSTONES)) {
            return TombstoneBlock.Data.of(world.func_175625_s(pos)).filter(TombstoneBlock.Data::hasEntity).map(data -> {
                if (!context.func_195991_k().field_72995_K) {
                    CriterionMCA.GENERIC_EVENT_CRITERION.trigger((ServerPlayerEntity)context.func_195999_j(), cure ? "staffOfLife" : "scytheRevive");
                }
                if (!world.field_72995_K && !data.isResurrecting()) {
                    data.startResurrecting(cure);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }).orElse(ActionResultType.FAIL);
        }
        return ActionResultType.PASS;
    }
}

