/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.MCA;
import forge.net.mca.MCAClient;
import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.client.model.PlayerEntityExtendedModel;
import forge.net.mca.client.model.VillagerEntityModelMCA;
import forge.net.mca.client.render.layer.ClothingLayer;
import forge.net.mca.client.render.layer.FaceLayer;
import forge.net.mca.client.render.layer.HairLayer;
import forge.net.mca.client.render.layer.SkinLayer;
import forge.net.mca.client.render.layer.VillagerLayer;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.util.compat.model.Dilation;
import forge.net.mca.util.compat.model.ModelData;
import forge.net.mca.util.compat.model.TexturedModelData;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class MixinPlayerEntityRenderer
extends LivingRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private PlayerModel<AbstractClientPlayerEntity> villagerModel;
    private PlayerModel<AbstractClientPlayerEntity> vanillaModel;
    SkinLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> skinLayer;
    ClothingLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> clothingLayer;

    @Shadow
    protected abstract void func_177137_d(AbstractClientPlayerEntity var1);

    public MixinPlayerEntityRenderer(EntityRendererManager ctx, PlayerModel<AbstractClientPlayerEntity> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/render/entity/EntityRenderDispatcher;Z)V"}, at={@At(value="TAIL")})
    private void init(EntityRendererManager ctx, boolean slim, CallbackInfo ci) {
        if (MCA.isPlayerRendererAllowed()) {
            this.villagerModel = MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.bodyData(new Dilation(0.0f), slim));
            this.vanillaModel = (PlayerModel)this.field_77045_g;
            this.skinLayer = new SkinLayer(this, MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.bodyData(new Dilation(0.0f))));
            this.func_177094_a(this.skinLayer);
            this.func_177094_a(new FaceLayer(this, MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.bodyData(new Dilation(0.01f))), "normal"));
            this.clothingLayer = new ClothingLayer(this, MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.bodyData(new Dilation(0.0625f))), "normal");
            this.func_177094_a(this.clothingLayer);
            this.func_177094_a(new HairLayer(this, MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.hairData(new Dilation(0.125f)))));
        }
    }

    private static PlayerEntityExtendedModel<AbstractClientPlayerEntity> createModel(ModelData data) {
        return new PlayerEntityExtendedModel<AbstractClientPlayerEntity>(TexturedModelData.of(data, 64, 64).createModel());
    }

    @Inject(method={"scale(Lnet/minecraft/client/network/AbstractClientPlayerEntity;Lnet/minecraft/client/util/math/MatrixStack;F)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectScale(AbstractClientPlayerEntity villager, MatrixStack matrices, float f, CallbackInfo ci) {
        if (MCAClient.useGeneticsRenderer(villager.func_110124_au())) {
            float height = CommonVillagerModel.getVillager((Entity)villager).getRawScaleFactor();
            float width = CommonVillagerModel.getVillager((Entity)villager).getHorizontalScaleFactor();
            matrices.func_227862_a_(width, height, width);
            if (CommonVillagerModel.getVillager((Entity)villager).getAgeState() == AgeState.BABY && !villager.func_184218_aH()) {
                matrices.func_227861_a_(0.0, (double)0.6f, 0.0);
            }
            ci.cancel();
            this.field_77045_g = this.villagerModel;
        } else if (MCA.isPlayerRendererAllowed()) {
            this.field_77045_g = this.vanillaModel;
        }
    }

    @Inject(method={"renderRightArm(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectRenderRightArm(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, AbstractClientPlayerEntity player, CallbackInfo ci) {
        if (MCAClient.renderArms(player.func_110124_au(), "right_arm")) {
            this.renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.skinLayer.model).field_178723_h, ((PlayerModel)this.skinLayer.model).field_178732_b, this.skinLayer);
            this.renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.clothingLayer.model).field_178723_h, ((PlayerModel)this.clothingLayer.model).field_178732_b, this.clothingLayer);
            ci.cancel();
        }
    }

    @Inject(method={"renderLeftArm(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectRenderLeftArm(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, AbstractClientPlayerEntity player, CallbackInfo ci) {
        if (MCAClient.renderArms(player.func_110124_au(), "left_arm")) {
            this.renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.skinLayer.model).field_178724_i, ((PlayerModel)this.skinLayer.model).field_178734_a, this.skinLayer);
            this.renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.clothingLayer.model).field_178724_i, ((PlayerModel)this.clothingLayer.model).field_178734_a, this.clothingLayer);
            ci.cancel();
        }
    }

    private void renderCustomArm(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, AbstractClientPlayerEntity player, ModelRenderer arm, ModelRenderer sleeve, VillagerLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> layer) {
        PlayerEntityExtendedModel model = (PlayerEntityExtendedModel)layer.model;
        this.func_177137_d(player);
        model.field_217112_c = 0.0f;
        model.field_228270_o_ = false;
        model.field_205061_a = 0.0f;
        model.func_225597_a_(player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        model.func_178719_a(false);
        arm.field_78806_j = true;
        arm.field_78795_f = 0.0f;
        arm.field_78796_g = 0.0f;
        arm.field_78808_h = 0.0f;
        sleeve.field_78806_j = true;
        sleeve.field_78795_f = 0.0f;
        sleeve.field_78796_g = 0.0f;
        sleeve.field_78808_h = 0.0f;
        model.applyVillagerDimensions(CommonVillagerModel.getVillager((Entity)player), player.func_213453_ef());
        layer.renderFinal(matrices, vertexConsumers, light, player, 0.0f);
        model.func_178719_a(true);
    }
}

