/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.mixin;

import forge.net.mca.server.SpawnQueue;
import forge.net.mca.server.world.data.VillageManager;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerWorld.class})
abstract class MixinServerWorld
extends World
implements ISeedReader {
    MixinServerWorld() {
        super(null, null, null, null, true, false, 0L);
    }

    @Inject(method={"addEntity(Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddEntity(Entity entity, CallbackInfoReturnable<Boolean> info) {
        if (SpawnQueue.getInstance().addVillager(entity)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onBlockChanged(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;)V"}, at={@At(value="HEAD")})
    public void onOnBlockChanged(BlockPos pos, BlockState oldBlock, BlockState newBlock, CallbackInfo info) {
        if (oldBlock.func_177230_c() != newBlock.func_177230_c()) {
            ServerWorld self = (ServerWorld)this;
            self.func_73046_m().execute(() -> VillageManager.get(self).getReaperSpawner().trySpawnReaper(self, newBlock, pos));
        }
    }
}

