/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.mixin;

import forge.net.mca.ducks.IVillagerEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ZombieVillagerEntity.class})
abstract class MixinZombieVillagerEntity
implements IVillagerEntity {
    @Nullable
    private transient SpawnReason reason;

    MixinZombieVillagerEntity() {
    }

    @Override
    public SpawnReason getSpawnReason() {
        return this.reason == null ? SpawnReason.NATURAL : this.reason;
    }

    @Inject(method={"initialize"}, at={@At(value="HEAD")})
    private void onInitialize(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT entityNbt, CallbackInfoReturnable<ILivingEntityData> info) {
        this.reason = spawnReason;
    }

    @ModifyVariable(method={"setVillagerData"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private VillagerData setVillagerData(VillagerData villagerData) {
        VillagerProfession profession = villagerData.func_221130_b();
        if (profession.toString().startsWith("mca.")) {
            villagerData = villagerData.func_221126_a(VillagerProfession.field_221151_a);
        }
        return villagerData;
    }
}

