/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.network;

import forge.net.mca.Config;
import forge.net.mca.MCAClient;
import forge.net.mca.client.book.Book;
import forge.net.mca.client.gui.BlueprintScreen;
import forge.net.mca.client.gui.CombScreen;
import forge.net.mca.client.gui.ExtendedBookScreen;
import forge.net.mca.client.gui.FamilyTreeScreen;
import forge.net.mca.client.gui.FamilyTreeSearchScreen;
import forge.net.mca.client.gui.InteractScreen;
import forge.net.mca.client.gui.LimitedVillagerEditorScreen;
import forge.net.mca.client.gui.NameBabyScreen;
import forge.net.mca.client.gui.NeedleScreen;
import forge.net.mca.client.gui.VillagerEditorScreen;
import forge.net.mca.client.gui.WhistleScreen;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.item.BabyItem;
import forge.net.mca.item.ExtendedWrittenBookItem;
import forge.net.mca.network.ClientInteractionManager;
import forge.net.mca.network.s2c.AnalysisResults;
import forge.net.mca.network.s2c.BabyNameResponse;
import forge.net.mca.network.s2c.FamilyTreeUUIDResponse;
import forge.net.mca.network.s2c.GetChildDataResponse;
import forge.net.mca.network.s2c.GetFamilyResponse;
import forge.net.mca.network.s2c.GetFamilyTreeResponse;
import forge.net.mca.network.s2c.GetInteractDataResponse;
import forge.net.mca.network.s2c.GetVillageFailedResponse;
import forge.net.mca.network.s2c.GetVillageResponse;
import forge.net.mca.network.s2c.GetVillagerResponse;
import forge.net.mca.network.s2c.InteractionDialogueResponse;
import forge.net.mca.network.s2c.OpenDestinyGuiRequest;
import forge.net.mca.network.s2c.OpenGuiRequest;
import forge.net.mca.network.s2c.PlayerDataMessage;
import forge.net.mca.network.s2c.ShowToastRequest;
import forge.net.mca.network.s2c.SkinListResponse;
import forge.net.mca.network.s2c.VillagerNameResponse;
import forge.net.mca.server.world.data.BabyTracker;
import forge.net.mca.server.world.data.Village;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ClientInteractionManagerImpl
implements ClientInteractionManager {
    private final Minecraft client = Minecraft.func_71410_x();

    @Override
    public void handleGuiRequest(OpenGuiRequest message) {
        assert (this.client.field_71441_e != null);
        assert (Minecraft.func_71410_x().field_71439_g != null);
        switch (message.getGui()) {
            case WHISTLE: {
                this.client.func_147108_a((Screen)new WhistleScreen());
                break;
            }
            case BOOK: {
                ItemStack item;
                if (this.client.field_71439_g == null || !((item = this.client.field_71439_g.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof ExtendedWrittenBookItem)) break;
                ExtendedWrittenBookItem bookItem = (ExtendedWrittenBookItem)item.func_77973_b();
                Book book = bookItem.getBook(item);
                this.client.func_147108_a((Screen)new ExtendedBookScreen(book));
                break;
            }
            case BLUEPRINT: {
                this.client.func_147108_a((Screen)new BlueprintScreen());
                break;
            }
            case INTERACT: {
                ItemStack item;
                boolean isOnBlacklist;
                if (this.client.field_71439_g == null || (isOnBlacklist = Config.getInstance().villagerInteractionItemBlacklist.contains(Registry.field_212630_s.func_177774_c((Object)(item = this.client.field_71439_g.func_184586_b(Hand.MAIN_HAND)).func_77973_b()).toString()))) break;
                VillagerLike villager = (VillagerLike)this.client.field_71441_e.func_73045_a(message.villager);
                this.client.func_147108_a((Screen)new InteractScreen(villager));
                break;
            }
            case VILLAGER_EDITOR: {
                Entity entity = this.client.field_71441_e.func_73045_a(message.villager);
                assert (entity != null);
                this.client.func_147108_a((Screen)new VillagerEditorScreen(entity.func_110124_au(), Minecraft.func_71410_x().field_71439_g.func_110124_au()));
                break;
            }
            case LIMITED_VILLAGER_EDITOR: {
                Entity entity = this.client.field_71441_e.func_73045_a(message.villager);
                assert (entity != null);
                this.client.func_147108_a((Screen)new LimitedVillagerEditorScreen(entity.func_110124_au(), Minecraft.func_71410_x().field_71439_g.func_110124_au()));
                break;
            }
            case NEEDLE_AND_THREAD: {
                Entity entity = this.client.field_71441_e.func_73045_a(message.villager);
                if (entity == null) {
                    this.client.func_147108_a((Screen)new NeedleScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au()));
                    break;
                }
                this.client.func_147108_a((Screen)new NeedleScreen(entity.func_110124_au(), Minecraft.func_71410_x().field_71439_g.func_110124_au()));
                break;
            }
            case COMB: {
                Entity entity = this.client.field_71441_e.func_73045_a(message.villager);
                if (entity == null) {
                    this.client.func_147108_a((Screen)new CombScreen(Minecraft.func_71410_x().field_71439_g.func_110124_au()));
                    break;
                }
                this.client.func_147108_a((Screen)new CombScreen(entity.func_110124_au(), Minecraft.func_71410_x().field_71439_g.func_110124_au()));
                break;
            }
            case BABY_NAME: {
                ItemStack item;
                if (this.client.field_71439_g == null || !((item = this.client.field_71439_g.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof BabyItem)) break;
                this.client.func_147108_a((Screen)new NameBabyScreen((PlayerEntity)this.client.field_71439_g, item));
                break;
            }
            case FAMILY_TREE: {
                this.client.func_147108_a((Screen)new FamilyTreeSearchScreen());
                break;
            }
        }
    }

    @Override
    public void handleFamilyTreeResponse(GetFamilyTreeResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof FamilyTreeScreen) {
            FamilyTreeScreen gui = (FamilyTreeScreen)screen;
            gui.setFamilyData(message.uuid, message.family);
        }
    }

    @Override
    public void handleInteractDataResponse(GetInteractDataResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setConstraints(message.constraints);
            gui.setParents(message.father, message.mother);
            gui.setSpouse(message.marriageState, message.spouse);
        }
    }

    @Override
    public void handleVillageDataResponse(GetVillageResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof BlueprintScreen) {
            Village village = new Village();
            village.load(message.getData());
            BlueprintScreen gui = (BlueprintScreen)screen;
            gui.setVillage(village);
            gui.setRank(message.rank, message.reputation, message.isVillage, message.ids, message.tasks, message.buildingTypes);
        }
    }

    @Override
    public void handleVillageDataFailedResponse(GetVillageFailedResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            gui.setVillage(null);
        }
    }

    @Override
    public void handleFamilyDataResponse(GetFamilyResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof WhistleScreen) {
            WhistleScreen gui = (WhistleScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleVillagerDataResponse(GetVillagerResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleDialogueResponse(InteractionDialogueResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setDialogue(message.question, message.answers, message.silent);
        }
    }

    @Override
    public void handleChildData(GetChildDataResponse message) {
        BabyItem.CLIENT_STATE_CACHE.put((Object)message.id, Optional.ofNullable(message.getData()).map(BabyTracker.ChildSaveState::new));
    }

    @Override
    public void handleSkinListResponse(AnalysisResults message) {
        InteractScreen.setAnalysis(message.analysis);
    }

    @Override
    public void handleBabyNameResponse(BabyNameResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof NameBabyScreen) {
            NameBabyScreen gui = (NameBabyScreen)screen;
            gui.setBabyName(message.getName());
        }
    }

    @Override
    public void handleVillagerNameResponse(VillagerNameResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerName(message.getName());
        }
    }

    @Override
    public void handleToastMessage(ShowToastRequest message) {
        SystemToast.func_238536_a_((ToastGui)this.client.func_193033_an(), (SystemToast.Type)SystemToast.Type.TUTORIAL_HINT, (ITextComponent)message.getTitle(), (ITextComponent)message.getMessage());
    }

    @Override
    public void handleFamilyTreeUUIDResponse(FamilyTreeUUIDResponse response) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof FamilyTreeSearchScreen) {
            FamilyTreeSearchScreen gui = (FamilyTreeSearchScreen)screen;
            gui.setList(response.getList());
        }
    }

    @Override
    public void handlePlayerDataMessage(PlayerDataMessage response) {
        VillagerEntityMCA villager = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        assert (villager != null);
        villager.func_70037_a(response.getData());
        MCAClient.playerData.put(response.uuid, villager);
    }

    @Override
    public void handleSkinListResponse(SkinListResponse message) {
        Screen screen = this.client.field_71462_r;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setSkinList(message.getClothing(), message.getHair());
        }
    }

    @Override
    public void handleDestinyGuiRequest(OpenDestinyGuiRequest message) {
        MCAClient.getDestinyManager().requestOpen(message.allowTeleportation);
    }
}

