/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.network.c2s;

import forge.net.mca.Config;
import forge.net.mca.cobalt.network.Message;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.compat.FuzzyPositionsCompat;
import java.util.EnumSet;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.TicketType;

public class DestinyMessage
implements Message {
    private static final long serialVersionUID = -782119062565197963L;
    private final String location;
    private final boolean isClosing;

    public DestinyMessage(String location, boolean isClosing) {
        this.location = location;
        this.isClosing = isClosing;
    }

    public DestinyMessage(String location) {
        this(location, false);
    }

    public DestinyMessage(boolean isClosing) {
        this(null, isClosing);
    }

    @Override
    public void receive(ServerPlayerEntity player) {
        if (this.isClosing && player.func_175149_v()) {
            player.func_71033_a(GameType.SURVIVAL);
        }
        if (Config.getInstance().allowDestinyTeleportation && this.location != null) {
            WorldUtils.getClosestStructurePosition(player.func_71121_q(), player.func_233580_cy_(), new ResourceLocation(this.location), 100).ifPresent(pos -> {
                player.func_71121_q().func_175726_f(pos);
                pos = player.func_71121_q().func_205770_a(Heightmap.Type.WORLD_SURFACE, pos);
                pos = FuzzyPositionsCompat.upWhile(pos, player.func_71121_q().func_217301_I(), p -> player.func_71121_q().func_180495_p(p).func_229980_m_((IBlockReader)player.func_71121_q(), p));
                pos = FuzzyPositionsCompat.downWhile(pos, 1, p -> !player.func_71121_q().func_180495_p(p.func_177977_b()).func_235785_r_((IBlockReader)player.func_71121_q(), p));
                ChunkPos chunkPos = new ChunkPos(pos);
                player.func_71121_q().func_72863_F().func_217228_a(TicketType.field_223185_g, chunkPos, 1, (Object)player.func_145782_y());
                player.field_71135_a.func_175089_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A, EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class));
                player.func_242111_a(player.field_70170_p.func_234923_W_(), pos, 0.0f, true, false);
                if (player.field_70170_p.func_73046_m() != null && player.field_70170_p.func_73046_m().func_213199_b(player.func_146103_bH())) {
                    player.func_71121_q().func_241124_a__(pos, 0.0f);
                }
            });
        }
    }
}

