/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.network.c2s;

import forge.net.mca.cobalt.network.Message;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.network.s2c.GetVillagerResponse;
import forge.net.mca.server.world.data.PlayerSaveData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.world.server.ServerWorld;

public class GetVillagerRequest
implements Message {
    private static final long serialVersionUID = -4415670234855916259L;
    private final UUID uuid;

    public GetVillagerRequest(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public void receive(ServerPlayerEntity player) {
        Entity e = player.func_71121_q().func_217461_a(this.uuid);
        CompoundNBT villagerData = GetVillagerRequest.getVillagerData(e);
        if (villagerData != null) {
            NetworkHandler.sendToPlayer(new GetVillagerResponse(villagerData), player);
        }
    }

    private static void storeNode(CompoundNBT data, Optional<FamilyTreeNode> entry, String prefix) {
        if (entry.isPresent()) {
            data.func_74778_a("tree_" + prefix + "_name", entry.get().getName());
            data.func_186854_a("tree_" + prefix + "_uuid", entry.get().id());
        } else {
            data.func_74778_a("tree_" + prefix + "_name", "");
            data.func_186854_a("tree_" + prefix + "_uuid", Util.field_240973_b_);
        }
    }

    public static CompoundNBT getVillagerData(Entity e) {
        CompoundNBT data;
        if (e instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)e;
            data = PlayerSaveData.get(serverPlayer).getEntityData();
        } else if (e instanceof LivingEntity) {
            data = new CompoundNBT();
            ((MobEntity)e).func_213281_b(data);
        } else {
            return null;
        }
        FamilyTree tree = FamilyTree.get((ServerWorld)e.field_70170_p);
        FamilyTreeNode entry = tree.getOrCreate(e);
        GetVillagerRequest.storeNode(data, tree.getOrEmpty(entry.partner()), "spouse");
        GetVillagerRequest.storeNode(data, tree.getOrEmpty(entry.father()), "father");
        GetVillagerRequest.storeNode(data, tree.getOrEmpty(entry.mother()), "mother");
        return data;
    }
}

