/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.network.c2s;

import forge.net.mca.cobalt.network.Message;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.GraveyardManager;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.server.world.data.VillageManager;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ReportBuildingMessage
implements Message {
    private static final long serialVersionUID = 3510050513221709603L;
    private final Action action;
    private final String data;

    public ReportBuildingMessage(Action action, String data) {
        this.action = action;
        this.data = data;
    }

    public ReportBuildingMessage(Action action) {
        this(action, null);
    }

    @Override
    public void receive(ServerPlayerEntity player) {
        VillageManager villages = VillageManager.get(player.func_71121_q());
        switch (this.action) {
            case ADD: 
            case ADD_ROOM: {
                Building.validationResult result = villages.processBuilding(player.func_233580_cy_(), true, this.action == Action.ADD_ROOM);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("blueprint.scan." + result.name().toLowerCase(Locale.ENGLISH)), true);
                GraveyardManager.get(player.func_71121_q()).reportToVillageManager((Entity)player);
                break;
            }
            case AUTO_SCAN: {
                villages.findNearestVillage((Entity)player).ifPresent(Village::toggleAutoScan);
                break;
            }
            case FULL_SCAN: {
                villages.findNearestVillage((Entity)player).ifPresent(buildings -> new ArrayList<Building>(buildings.getBuildings().values()).forEach(b -> villages.processBuilding(b.getCenter(), true, false)));
                break;
            }
            case FORCE_TYPE: 
            case REMOVE: {
                Optional<Village> village = villages.findNearestVillage((Entity)player);
                Optional building = village.flatMap(v -> v.getBuildings().values().stream().filter(b -> b.containsPos((Vector3i)player.func_233580_cy_())).findAny());
                if (building.isPresent()) {
                    if (this.action == Action.FORCE_TYPE) {
                        if (((Building)building.get()).getType().equals(this.data)) {
                            ((Building)building.get()).determineType();
                            break;
                        }
                        ((Building)building.get()).setForcedType(this.data);
                        break;
                    }
                    village.get().removeBuilding(((Building)building.get()).getId());
                    village.get().markDirty(player.func_71121_q());
                    break;
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("blueprint.noBuilding"), true);
            }
        }
    }

    public static enum Action {
        AUTO_SCAN,
        ADD_ROOM,
        ADD,
        REMOVE,
        FORCE_TYPE,
        FULL_SCAN;

    }
}

