/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.network.c2s;

import forge.net.mca.MCA;
import forge.net.mca.cobalt.network.Message;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.network.NbtDataMessage;
import forge.net.mca.network.c2s.GetVillagerRequest;
import forge.net.mca.network.s2c.PlayerDataMessage;
import forge.net.mca.resources.ClothingList;
import forge.net.mca.resources.HairList;
import forge.net.mca.server.world.data.PlayerSaveData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class VillagerEditorSyncRequest
extends NbtDataMessage
implements Message {
    private static final long serialVersionUID = -5581564927127176555L;
    private final String command;
    private final UUID uuid;

    public VillagerEditorSyncRequest(String command, UUID uuid, CompoundNBT data) {
        super(data);
        this.command = command;
        this.uuid = uuid;
    }

    private void setHair(ServerPlayerEntity player, Entity entity) {
        CompoundNBT villagerData = GetVillagerRequest.getVillagerData(entity);
        if (villagerData != null) {
            String hair = this.getData().func_74764_b("offset") ? HairList.getInstance().getPool(this.getGender(villagerData)).pickNext(villagerData.func_74779_i("hair"), this.getData().func_74762_e("offset")) : HairList.getInstance().getPool(this.getGender(villagerData)).pickOne();
            villagerData.func_74778_a("hair", hair);
            this.saveEntity(player, entity, villagerData);
        }
    }

    private void setClothing(ServerPlayerEntity player, Entity entity) {
        CompoundNBT villagerData = GetVillagerRequest.getVillagerData(entity);
        if (villagerData != null) {
            String clothes = "mca:missing";
            if (entity instanceof PlayerEntity) {
                clothes = this.getData().func_74764_b("offset") ? ClothingList.getInstance().getPool(this.getGender(villagerData), VillagerProfession.field_221151_a).pickNext(villagerData.func_74779_i("clothes"), this.getData().func_74762_e("offset")) : ClothingList.getInstance().getPool(this.getGender(villagerData), VillagerProfession.field_221151_a).pickOne();
            } else if (entity instanceof VillagerLike) {
                VillagerLike villager = (VillagerLike)entity;
                clothes = this.getData().func_74764_b("offset") ? ClothingList.getInstance().getPool(villager).pickNext(villager.getClothes(), this.getData().func_74762_e("offset")) : ClothingList.getInstance().getPool(villager).pickOne();
            }
            villagerData.func_74778_a("clothes", clothes);
            this.saveEntity(player, entity, villagerData);
        }
    }

    @Override
    public void receive(ServerPlayerEntity player) {
        Entity entity = player.func_71121_q().func_217461_a(this.uuid);
        switch (this.command) {
            case "hair": {
                this.setHair(player, entity);
                break;
            }
            case "clothing": {
                this.setClothing(player, entity);
                break;
            }
            case "gender": {
                this.setHair(player, entity);
                this.setClothing(player, entity);
                break;
            }
            case "sync": {
                this.saveEntity(player, entity, this.getData());
                break;
            }
            case "profession": {
                if (!(entity instanceof VillagerEntityMCA)) break;
                VillagerProfession profession = (VillagerProfession)Registry.field_218370_L.func_82594_a(new ResourceLocation(this.getData().func_74779_i("profession")));
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                villager.setProfession(profession);
            }
        }
        this.getData();
    }

    private void saveEntity(ServerPlayerEntity player, Entity entity, CompoundNBT villagerData) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)entity;
            PlayerSaveData data = PlayerSaveData.get(serverPlayer);
            data.setEntityData(villagerData);
            data.setEntityDataSet(true);
            this.syncFamilyTree(player, entity, villagerData);
            serverPlayer.func_71121_q().func_217369_A().forEach(p -> NetworkHandler.sendToPlayer(new PlayerDataMessage(player.func_110124_au(), villagerData), p));
        } else if (entity instanceof VillagerLike) {
            ((LivingEntity)entity).func_70037_a(villagerData);
            entity.func_213323_x_();
            this.syncFamilyTree(player, entity, villagerData);
            if (entity instanceof VillagerEntityMCA) {
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                villager.getResidency().getHomeBuilding().ifPresent(b -> b.updateResident((Entity)villager));
            }
        }
    }

    private Gender getGender(CompoundNBT villagerData) {
        return Gender.byId(villagerData.func_74762_e("gender"));
    }

    private Optional<FamilyTreeNode> getFamilyNode(ServerPlayerEntity player, FamilyTree tree, String name, Gender gender) {
        try {
            UUID uuid = UUID.fromString(name);
            Optional<FamilyTreeNode> node = tree.getOrEmpty(uuid);
            if (node.isPresent()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.villager_editor.uuid_known", new Object[]{name, node.get().getName()}), true);
                return node;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.villager_editor.uuid_unknown", new Object[]{name}).func_240699_a_(TextFormatting.RED), true);
            return Optional.empty();
        }
        catch (IllegalArgumentException exception) {
            List nodes = tree.getAllWithName(name).collect(Collectors.toList());
            if (nodes.isEmpty()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.villager_editor.name_created", new Object[]{name}).func_240699_a_(TextFormatting.YELLOW), true);
                return Optional.of(tree.getOrCreate(UUID.randomUUID(), name, gender));
            }
            if (nodes.size() > 1) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.villager_editor.name_not_unique", new Object[]{name}).func_240699_a_(TextFormatting.RED), true);
                String uuids = nodes.stream().map(FamilyTreeNode::id).map(UUID::toString).collect(Collectors.joining(", "));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.villager_editor.list_of_ids", new Object[]{uuids}), false);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.villager_editor.name_unique", new Object[]{name}), true);
            }
            return Optional.ofNullable((FamilyTreeNode)nodes.get(0));
        }
    }

    private void syncFamilyTree(ServerPlayerEntity player, Entity entity, CompoundNBT villagerData) {
        String name;
        FamilyTree tree = FamilyTree.get((ServerWorld)entity.field_70170_p);
        FamilyTreeNode entry = tree.getOrCreate(entity);
        entry.setGender(this.getGender(this.getData()));
        entry.setName(this.getData().func_74779_i("villagerName"));
        if (villagerData.func_74764_b("tree_father_new")) {
            name = villagerData.func_74779_i("tree_father_new");
            if (MCA.isBlankString(name)) {
                entry.removeFather();
            } else {
                this.getFamilyNode(player, tree, name, Gender.MALE).ifPresent(entry::setFather);
            }
        }
        if (villagerData.func_74764_b("tree_mother_new")) {
            name = villagerData.func_74779_i("tree_mother_new");
            if (MCA.isBlankString(name)) {
                entry.removeMother();
            } else {
                this.getFamilyNode(player, tree, name, Gender.FEMALE).ifPresent(entry::setMother);
            }
        }
        if (villagerData.func_74764_b("tree_spouse_new")) {
            name = villagerData.func_74779_i("tree_spouse_new");
            if (MCA.isBlankString(name)) {
                Optional.of(entry.partner()).flatMap(tree::getOrEmpty).ifPresent(node -> node.updatePartner(null, null));
                entry.updatePartner(null, null);
            } else {
                this.getFamilyNode(player, tree, name, entry.gender().opposite()).ifPresent(node -> {
                    entry.updatePartner((FamilyTreeNode)node);
                    node.updatePartner(entry);
                });
            }
        }
    }
}

