/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.resources.Resources;
import forge.net.mca.resources.WeightedPool;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.Nullable;

public class ClothingList
extends JsonReloadListener {
    protected static final ResourceLocation ID = MCA.locate("skins/clothing");
    public final HashMap<String, Clothing> clothing = new HashMap();
    private static ClothingList INSTANCE;

    public static ClothingList getInstance() {
        return INSTANCE;
    }

    public ClothingList() {
        super(Resources.GSON, "skins/clothing");
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, IResourceManager manager, IProfiler profiler) {
        this.clothing.clear();
        data.forEach((id, file) -> {
            Gender gender = Gender.byName(id.func_110623_a().split("\\.")[0]);
            if (gender == Gender.UNASSIGNED) {
                MCA.LOGGER.warn("Invalid gender for clothing pool: {}", id);
                return;
            }
            for (Map.Entry entry : file.getAsJsonObject().entrySet()) {
                String key = (String)entry.getKey();
                JsonObject object = file.getAsJsonObject().get(key).getAsJsonObject();
                for (int i = 0; i < JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1); ++i) {
                    String identifier = String.format(key, i);
                    Clothing c = new Clothing(identifier);
                    c.gender = gender;
                    c.profession = JSONUtils.func_151219_a((JsonObject)object, (String)"profession", null);
                    c.chance = JSONUtils.func_151221_a((JsonObject)object, (String)"chance", (float)1.0f);
                    c.exclude = JSONUtils.func_151209_a((JsonObject)object, (String)"exclude", (boolean)false);
                    c.temperature = JSONUtils.func_151208_a((JsonObject)object, (String)"temperature", (int)0);
                    if (this.clothing.containsKey(identifier) && object.has("count")) continue;
                    this.clothing.put(identifier, c);
                }
            }
        });
    }

    public WeightedPool<String> getPool(VillagerLike<?> villager) {
        Gender gender = villager.getGenetics().getGender();
        switch (villager.getAgeState()) {
            case BABY: 
            case TODDLER: {
                return this.getPool(gender, MCA.locate("baby").toString());
            }
            case CHILD: 
            case TEEN: {
                return this.getPool(gender, MCA.locate("child").toString());
            }
        }
        WeightedPool<String> pool = this.getPool(gender, villager.func_213700_eh().func_221130_b());
        if (pool.entries.size() == 0) {
            pool = this.getPool(gender, VillagerProfession.field_221151_a);
        }
        return pool;
    }

    public WeightedPool<String> getPool(Gender gender, @Nullable VillagerProfession profession) {
        Map<String, String> map = Config.getInstance().professionConversionsMap;
        String currentValue = profession == null ? "minecraft:none" : Registry.field_218370_L.func_177774_c((Object)profession).toString();
        String identifier = map.getOrDefault(currentValue, map.getOrDefault("default", currentValue));
        return this.getPool(gender, identifier);
    }

    public WeightedPool<String> getPool(Gender gender, @Nullable String profession) {
        return this.clothing.values().stream().filter(c -> c.gender == Gender.NEUTRAL || gender == Gender.NEUTRAL || c.gender == gender).filter(c -> c.profession == null || profession == null && !c.exclude || c.profession.equals(profession)).collect(() -> new WeightedPool.Mutable<String>("mca:missing"), (list, entry) -> list.add(entry.identifier, entry.chance), (a, b) -> a.entries.addAll(b.entries));
    }

    public static class Clothing
    extends ListEntry {
        @Nullable
        public String profession;
        public float temperature;
        public boolean exclude;

        public Clothing(String identifier) {
            super(identifier);
        }
    }

    public static class ListEntry
    implements Serializable {
        final String identifier;
        public Gender gender;
        public float chance;

        public ListEntry(String identifier) {
            this.identifier = identifier;
        }
    }
}

