/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources;

import com.google.gson.JsonElement;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.resources.Resources;
import forge.net.mca.resources.WeightedPool;
import forge.net.mca.server.world.data.Nationality;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

public class Names
extends JsonReloadListener {
    protected static final ResourceLocation ID = MCA.locate("names");
    public static final List<Map<Gender, WeightedPool<String>>> NAMES = new ArrayList<Map<Gender, WeightedPool<String>>>();
    public static final Map<String, Map<Gender, WeightedPool<String>>> NAMES_MAP = new HashMap<String, Map<Gender, WeightedPool<String>>>();
    static Random random = new Random();

    public Names() {
        super(Resources.GSON, ID.func_110623_a());
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, IResourceManager manager, IProfiler profiler) {
        NAMES_MAP.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : prepared.entrySet()) {
            String[] split = entry.getKey().func_110623_a().split("/");
            Gender gender = Gender.byName(split[1]);
            Map map = NAMES_MAP.computeIfAbsent(split[0], a -> new HashMap());
            WeightedPool.Mutable<String> names = new WeightedPool.Mutable<String>("?");
            for (Map.Entry elementEntry : entry.getValue().getAsJsonObject().entrySet()) {
                names.add((String)elementEntry.getKey(), (float)Math.pow(((JsonElement)elementEntry.getValue()).getAsInt(), 0.5));
            }
            map.put(gender, names);
        }
        NAMES.clear();
        Arrays.stream(NAMES_MAP.keySet().toArray()).sorted().forEach(n -> NAMES.add(NAMES_MAP.get((String)n)));
    }

    public static String pickCitizenName(@NotNull Gender gender, Entity entity) {
        Map<Gender, WeightedPool<String>> countries;
        if (Config.getInstance().useModernUSANamesOnly) {
            countries = NAMES_MAP.get("modernusa");
        } else {
            int i = Nationality.get((ServerWorld)entity.field_70170_p).getRegionId(entity.func_233580_cy_());
            countries = NAMES.get(Math.floorMod(i, NAMES.size()));
        }
        return countries.get((Object)gender.binary()).pickOne();
    }

    public static String pickCitizenName(@NotNull Gender gender) {
        return NAMES.get(random.nextInt(NAMES.size())).get((Object)gender.binary()).pickOne();
    }
}

