/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.net.mca.MCA;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.Resources;
import forge.net.mca.resources.data.tasks.AdvancementTask;
import forge.net.mca.resources.data.tasks.BlockingTask;
import forge.net.mca.resources.data.tasks.BuildingTask;
import forge.net.mca.resources.data.tasks.PopulationTask;
import forge.net.mca.resources.data.tasks.ReputationTask;
import forge.net.mca.resources.data.tasks.Task;
import forge.net.mca.server.world.data.Village;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class Tasks
extends JsonReloadListener {
    protected static final ResourceLocation ID = MCA.locate("tasks");
    private static Tasks INSTANCE;
    public final Map<Rank, List<Task>> tasks = new HashMap<Rank, List<Task>>();
    public static final Map<String, Function<JsonObject, Task>> TASK_TYPES;

    public static Tasks getInstance() {
        return INSTANCE;
    }

    public Tasks() {
        super(Resources.GSON, ID.func_110623_a());
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, IResourceManager manager, IProfiler profiler) {
        this.tasks.clear();
        for (Rank r : Rank.values()) {
            this.tasks.put(r, new LinkedList());
        }
        data.forEach((id, file) -> {
            Rank rank = Rank.fromName(id.func_110623_a().split("\\.")[0]);
            file.getAsJsonArray().forEach(entry -> {
                String type = JSONUtils.func_151200_h((JsonObject)entry.getAsJsonObject(), (String)"type");
                Function<JsonObject, Task> myNew = TASK_TYPES.get(type);
                Task task = myNew.apply(entry.getAsJsonObject());
                this.tasks.get((Object)rank).add(task);
            });
        });
    }

    public static Set<String> getCompletedIds(Village village, ServerPlayerEntity player) {
        return Tasks.getInstance().tasks.values().stream().flatMap(Collection::stream).filter(t -> t.isCompleted(village, player)).map(Task::getId).collect(Collectors.toSet());
    }

    public static Rank getRank(Village village, ServerPlayerEntity player) {
        Rank[] ranks = Rank.values();
        for (int i = ranks.length - 1; i >= 0; --i) {
            if (!Tasks.getInstance().tasks.get((Object)ranks[i]).stream().allMatch(t -> !t.isRequired() || t.isCompleted(village, player))) continue;
            return ranks[i];
        }
        return Rank.OUTLAW;
    }

    static {
        TASK_TYPES = new HashMap<String, Function<JsonObject, Task>>();
        TASK_TYPES.put("blocking", BlockingTask::new);
        TASK_TYPES.put("building", BuildingTask::new);
        TASK_TYPES.put("population", PopulationTask::new);
        TASK_TYPES.put("reputation", ReputationTask::new);
        TASK_TYPES.put("advancement", AdvancementTask::new);
    }
}

