/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources;

import forge.net.mca.resources.Resources;
import forge.net.mca.resources.data.BuildingType;
import forge.net.mca.resources.data.NameSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class VillageComponents
implements Iterable<BuildingType> {
    private final Map<String, BuildingType> buildingTypes = new HashMap<String, BuildingType>();
    private final Map<String, NameSet> namePool = new HashMap<String, NameSet>();
    private final Random rng;

    VillageComponents(Random rng) {
        this.rng = rng;
    }

    void load() throws Resources.BrokenResourceException {
        for (BuildingType bt : Resources.read("api/buildingTypes.json", BuildingType[].class)) {
            this.buildingTypes.put(bt.name(), bt);
        }
        this.namePool.put("village", Resources.read("api/names/village.json", NameSet.class));
    }

    public String pickVillageName(String from) {
        return this.namePool.getOrDefault(from, NameSet.DEFAULT).toName(this.rng);
    }

    public Map<String, BuildingType> getBuildingTypes() {
        return this.buildingTypes;
    }

    public BuildingType getBuildingType(String type) {
        return this.buildingTypes.containsKey(type) ? this.buildingTypes.get(type) : new BuildingType();
    }

    @Override
    public Iterator<BuildingType> iterator() {
        return this.buildingTypes.values().iterator();
    }
}

