/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources;

import forge.net.mca.resources.API;
import java.util.ArrayList;
import java.util.List;

public class WeightedPool<T> {
    private final T defaultValue;
    protected final List<Entry<T>> entries = new ArrayList<Entry<T>>();

    public WeightedPool(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T pickOne() {
        double totalChance = this.entries.stream().mapToDouble(a -> ((Entry)a).weight).sum() * API.getRng().nextDouble();
        for (Entry<T> e : this.entries) {
            if (!((totalChance -= (double)((Entry)e).weight) <= 0.0)) continue;
            return (T)((Entry)e).value;
        }
        return this.defaultValue;
    }

    public T pickNext(T current, int next) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!((Entry)this.entries.get(i)).value.equals(current)) continue;
            return (T)((Entry)this.entries.get(Math.floorMod(i + next, this.entries.size()))).value;
        }
        return this.pickOne();
    }

    public List<Entry<T>> getEntries() {
        return this.entries;
    }

    public static class Entry<T> {
        private final T value;
        private final float weight;

        public Entry(T value, float weight) {
            this.value = value;
            this.weight = weight;
        }

        public T getValue() {
            return this.value;
        }

        public float getWeight() {
            return this.weight;
        }
    }

    public static class Mutable<T>
    extends WeightedPool<T> {
        public Mutable(T defaultValue) {
            super(defaultValue);
        }

        public void add(T value, float weight) {
            this.entries.add(new Entry<T>(value, weight));
        }
    }
}

