/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources.data;

import forge.net.mca.MCA;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.architectury.hooks.TagHooks;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;

public final class BuildingType
implements Serializable {
    private static final long serialVersionUID = 2215455350801127280L;
    private final String name;
    private final int size;
    private final String color;
    private final int priority;
    private final boolean visible;
    private final Map<String, Integer> blocks;
    private transient Map<ResourceLocation, ResourceLocation> blockToGroup;
    private transient Map<ResourceLocation, Integer> groups;
    private final boolean icon;
    private final int iconU;
    private final int iconV;
    private final boolean grouped;
    private final int mergeRange;
    private final boolean noBeds;

    public BuildingType() {
        this("?", 0, "ffffffff", 0, true, false);
    }

    public BuildingType(String name, int size, String color, int priority, boolean visible, boolean noBeds) {
        this.name = name;
        this.size = size;
        this.color = color;
        this.priority = priority;
        this.visible = visible;
        this.noBeds = noBeds;
        this.blocks = Stream.of(new AbstractMap.SimpleEntry<String, Integer>("#minecraft:beds", 1000000000)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.blockToGroup = null;
        this.icon = false;
        this.iconU = 0;
        this.iconV = 0;
        this.grouped = false;
        this.mergeRange = 32;
    }

    public String name() {
        return this.name;
    }

    public int size() {
        return this.size;
    }

    public String color() {
        return this.color;
    }

    public int priority() {
        return this.priority;
    }

    public boolean visible() {
        return this.visible;
    }

    public int getColor() {
        return (int)Long.parseLong(this.color, 16);
    }

    public Map<ResourceLocation, ResourceLocation> getBlockToGroup() {
        if (this.blockToGroup == null) {
            this.blockToGroup = new HashMap<ResourceLocation, ResourceLocation>();
            this.groups = new HashMap<ResourceLocation, Integer>();
            for (Map.Entry<String, Integer> requirement : this.blocks.entrySet()) {
                ResourceLocation identifier;
                if (requirement.getKey().startsWith("#")) {
                    identifier = new ResourceLocation(requirement.getKey().substring(1));
                    ITag.INamedTag tag = TagHooks.getBlockOptional((ResourceLocation)identifier);
                    if (tag == null || tag.func_230236_b_().isEmpty()) {
                        MCA.LOGGER.error("Unknown building type tag " + identifier);
                    } else {
                        List entries = tag.func_230236_b_();
                        entries.forEach(b -> this.blockToGroup.putIfAbsent(Registry.field_212618_g.func_177774_c(b), identifier));
                    }
                } else {
                    identifier = new ResourceLocation(requirement.getKey());
                    this.blockToGroup.put(identifier, identifier);
                }
                this.groups.put(identifier, requirement.getValue());
            }
        }
        return this.blockToGroup;
    }

    public Map<ResourceLocation, Integer> getGroups() {
        this.getBlockToGroup();
        return this.groups;
    }

    public Map<ResourceLocation, List<BlockPos>> getGroups(Map<ResourceLocation, List<BlockPos>> blocks) {
        HashMap<ResourceLocation, List<BlockPos>> available = new HashMap<ResourceLocation, List<BlockPos>>();
        for (Map.Entry<ResourceLocation, List<BlockPos>> entry : blocks.entrySet()) {
            Optional.ofNullable(this.getBlockToGroup().get(entry.getKey())).ifPresent(v -> available.computeIfAbsent((ResourceLocation)v, k -> new LinkedList()).addAll((Collection)entry.getValue()));
        }
        return available;
    }

    public boolean isIcon() {
        return this.icon;
    }

    public int iconU() {
        return this.iconU * 20;
    }

    public int iconV() {
        return this.iconV * 60;
    }

    public boolean grouped() {
        return this.grouped;
    }

    public int mergeRange() {
        return this.mergeRange;
    }

    public boolean noBeds() {
        return this.noBeds;
    }
}

