/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources.data.analysis;

import forge.net.mca.resources.data.SerializablePair;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Analysis<T extends Serializable>
implements Serializable,
Iterable<AnalysisElement> {
    private static final long serialVersionUID = 2255112660663961645L;
    private final List<SerializablePair<String, T>> summands = new LinkedList<SerializablePair<String, T>>();

    public void add(String key, T value) {
        this.summands.add(new SerializablePair<String, T>(key, value));
    }

    public List<SerializablePair<String, T>> getSummands() {
        return this.summands;
    }

    public String getTotalAsString() {
        return this.asString(this.getTotal());
    }

    @Override
    @NotNull
    public Iterator<AnalysisElement> iterator() {
        return new Iterator<AnalysisElement>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Analysis.this.summands.size();
            }

            @Override
            public AnalysisElement next() {
                SerializablePair pair = (SerializablePair)Analysis.this.summands.get(this.i++);
                return new AnalysisElement(Analysis.this.isPositive(pair.getRight()), Analysis.this.asString(pair.getRight()), (String)pair.getLeft());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public abstract boolean isPositive(T var1);

    public abstract String asString(T var1);

    public abstract T getTotal();

    public static class AnalysisElement {
        private final boolean positive;
        private final String value;
        private final String key;

        public AnalysisElement(boolean positive, String value, String key) {
            this.positive = positive;
            this.value = value;
            this.key = key;
        }

        public boolean isPositive() {
            return this.positive;
        }

        public String getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }
    }
}

