/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources.data.dialogue;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.net.mca.MCA;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.LongTermMemory;
import forge.net.mca.network.s2c.InteractionDialogueResponse;
import forge.net.mca.resources.Dialogues;
import forge.net.mca.resources.data.dialogue.Question;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;

public class Actions {
    public static final Map<String, Factory<JsonElement>> TYPES = new HashMap<String, Factory<JsonElement>>();
    private final List<Action> actions;
    private final boolean positive;
    private final boolean negative;

    public static <T> void register(String name, BiFunction<JsonElement, String, T> jsonParser, Factory<T> predicate) {
        TYPES.put(name, json -> predicate.parse(jsonParser.apply((JsonElement)json, name)));
    }

    public static Actions fromJson(JsonObject json) {
        LinkedList<Action> actions = new LinkedList<Action>();
        boolean positive = false;
        boolean negative = false;
        for (Map.Entry entry : json.entrySet()) {
            if (TYPES.containsKey(entry.getKey())) {
                Action parsed = TYPES.get(entry.getKey()).parse((JsonElement)entry.getValue());
                actions.add(parsed);
                if (((String)entry.getKey()).equals("positive")) {
                    positive = true;
                }
                if (!((String)entry.getKey()).equals("negative")) continue;
                negative = true;
                continue;
            }
            MCA.LOGGER.info("Unknown dialogue action " + (String)entry.getKey());
        }
        if (!json.has("next")) {
            Action parsed = TYPES.get("quit").parse((JsonElement)json);
            actions.add(parsed);
        }
        return new Actions(actions, positive, negative);
    }

    public Actions(List<Action> actions, boolean positive, boolean negative) {
        this.actions = actions;
        this.positive = positive;
        this.negative = negative;
    }

    public void trigger(VillagerEntityMCA villager, ServerPlayerEntity player) {
        for (Action c : this.actions) {
            c.trigger(villager, player);
        }
    }

    public boolean isPositive() {
        return this.positive;
    }

    public boolean isNegative() {
        return this.negative;
    }

    static {
        Actions.register("next", JSONUtils::func_151206_a, id -> (villager, player) -> {
            if (id != null) {
                Question newQuestion = Dialogues.getInstance().getRandomQuestion((String)id);
                if (newQuestion != null) {
                    if (newQuestion.isAuto()) {
                        Dialogues.getInstance().selectAnswer(villager, player, newQuestion.getId(), newQuestion.getAnswers().get(0).getName());
                        return;
                    }
                    NetworkHandler.sendToPlayer(new InteractionDialogueResponse(newQuestion, player, villager), player);
                } else {
                    villager.sendChatMessage((PlayerEntity)player, "dialogue." + id, new Object[0]);
                }
                if (newQuestion == null || newQuestion.isCloseScreen()) {
                    villager.getInteractions().stopInteracting();
                }
            } else {
                villager.getInteractions().stopInteracting();
            }
        });
        Actions.register("say", JSONUtils::func_151206_a, id -> (villager, player) -> villager.sendChatMessage((PlayerEntity)player, "dialogue." + id, new Object[0]));
        Actions.register("remember", JSONUtils::func_151210_l, json -> (villager, player) -> {
            String id = LongTermMemory.parseId(json, player);
            if (json.has("time")) {
                villager.getLongTermMemory().remember(id, json.get("time").getAsLong());
            } else {
                villager.getLongTermMemory().remember(id);
            }
        });
        Actions.register("quit", (a, b) -> a, id -> (villager, player) -> villager.getInteractions().stopInteracting());
        Actions.register("negative", JSONUtils::func_151215_f, hearts -> (villager, player) -> {
            villager.getVillagerBrain().modifyMoodValue(-hearts.intValue());
            villager.getVillagerBrain().rewardHearts(player, -hearts.intValue());
        });
        Actions.register("positive", JSONUtils::func_151215_f, hearts -> (villager, player) -> {
            villager.getVillagerBrain().modifyMoodValue((int)hearts);
            villager.getVillagerBrain().rewardHearts(player, (int)hearts);
        });
        Actions.register("command", JSONUtils::func_151206_a, command -> (villager, player) -> villager.getInteractions().handle(player, (String)command));
    }

    public static interface Factory<T> {
        public Action parse(T var1);
    }

    public static interface Action {
        public void trigger(VillagerEntityMCA var1, ServerPlayerEntity var2);
    }
}

