/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.SoundsMCA;
import forge.net.mca.block.BlocksMCA;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.GrimReaperEntity;
import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.NbtHelper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;

public class ReaperSpawner {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private final Object lock = new Object();
    private final Map<Long, ActiveSummon> activeSummons = new HashMap<Long, ActiveSummon>();
    private final VillageManager manager;

    public ReaperSpawner(VillageManager manager) {
        this.manager = manager;
    }

    public ReaperSpawner(VillageManager manager, CompoundNBT nbt) {
        this.manager = manager;
        NbtHelper.toList((INBT)nbt.func_150295_c("summons", 10), n -> new ActiveSummon((CompoundNBT)n)).forEach(summon -> this.activeSummons.put(((ActiveSummon)summon).position.spawnPosition.func_218275_a(), (ActiveSummon)summon));
    }

    private void warn(World world, BlockPos pos, String phrase) {
        world.func_217369_A().stream().min(Comparator.comparingInt(a -> a.func_233580_cy_().func_218139_n((Vector3i)pos))).ifPresent(p -> p.func_146105_b((ITextComponent)new TranslationTextComponent(phrase).func_240699_a_(TextFormatting.RED), true));
    }

    public void trySpawnReaper(ServerWorld world, BlockState state, BlockPos pos) {
        if (!state.func_235714_a_((ITag)BlockTags.field_232872_am_)) {
            return;
        }
        if (!Config.getInstance().allowGrimReaper) {
            return;
        }
        ServerChunkProvider manager = world.func_72863_F();
        int range = 4;
        if (!(manager.func_73149_a(pos.func_177958_n() - range >> 4, pos.func_177952_p() - range >> 4) && manager.func_73149_a(pos.func_177958_n() + range >> 4, pos.func_177952_p() - range >> 4) && manager.func_73149_a(pos.func_177958_n() - range >> 4, pos.func_177952_p() + range >> 4) && manager.func_73149_a(pos.func_177958_n() + range >> 4, pos.func_177952_p() + range >> 4))) {
            return;
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150475_bE) {
            return;
        }
        MCA.LOGGER.info("Attempting to spawn reaper at {} in {}", (Object)pos, (Object)world.func_234923_W_().func_240901_a_());
        if (!this.isNightTime((World)world)) {
            this.warn((World)world, pos, "reaper.day");
            return;
        }
        Set<BlockPos> totems = this.getTotemsFires((World)world, pos);
        MCA.LOGGER.info("It is night time, found {} totems", (Object)totems.size());
        if (totems.size() < 3) {
            this.warn((World)world, pos, "reaper.totems");
            return;
        }
        this.start(new SummonPosition(pos, totems));
        EntityType.field_200728_aG.func_220342_a(world, null, null, null, pos, SpawnReason.TRIGGERED, false, false);
        world.func_180501_a(pos.func_177977_b(), Blocks.field_235336_cN_.func_176223_P(), 3);
        world.func_180501_a(pos, ((Block)BlocksMCA.INFERNAL_FLAME.get()).func_176223_P(), 3);
        totems.forEach(totem -> world.func_180501_a(totem, ((Block)BlocksMCA.INFERNAL_FLAME.get()).func_176223_P(), 18));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(SummonPosition pos) {
        Object object = this.lock;
        synchronized (object) {
            this.activeSummons.computeIfAbsent(pos.spawnPosition.func_218275_a(), ActiveSummon::new).start(pos);
            this.manager.markDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(ServerWorld world) {
        Object object = this.lock;
        synchronized (object) {
            boolean empty = this.activeSummons.isEmpty();
            this.activeSummons.values().removeIf(summon -> {
                try {
                    return summon.tick(world);
                }
                catch (Exception e) {
                    MCA.LOGGER.error("Exception ticking summon", (Throwable)e);
                    return true;
                }
            });
            if (!empty) {
                this.manager.markDirty();
            }
        }
    }

    private boolean isNightTime(World world) {
        long time = world.func_72820_D() % 24000L;
        MCA.LOGGER.info("Current time is {}", (Object)time);
        return time >= 13000L && time <= 23000L;
    }

    private Set<BlockPos> getTotemsFires(World world, BlockPos pos) {
        int groundY = pos.func_177956_o() - 2;
        int leftSkyHeight = world.func_217301_I() - groundY;
        int minPillarHeight = Math.min(Config.getInstance().minPillarHeight, leftSkyHeight);
        BlockPos.Mutable target = new BlockPos.Mutable();
        return Stream.of(HORIZONTALS).map(d -> target.func_189533_g((Vector3i)pos).func_181079_c(pos.func_177958_n(), groundY, pos.func_177952_p()).func_189534_c(d, 3)).filter(pillarPos -> {
            for (int height = 1; height <= leftSkyHeight; ++height) {
                pillarPos.func_181079_c(pillarPos.func_177958_n(), groundY + height, pillarPos.func_177952_p());
                if (world.func_180495_p((BlockPos)pillarPos).func_203425_a(Blocks.field_150343_Z)) continue;
                if (world.func_180495_p((BlockPos)pillarPos).func_235714_a_((ITag)BlockTags.field_232872_am_)) {
                    return height - 1 >= minPillarHeight;
                }
                return false;
            }
            return false;
        }).map(BlockPos::func_185334_h).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundNBT writeNbt() {
        Object object = this.lock;
        synchronized (object) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("summons", (INBT)NbtHelper.fromList(this.activeSummons.values(), ActiveSummon::write));
            return nbt;
        }
    }

    static class SummonPosition {
        public final BlockPos spawnPosition;
        public final BlockPos fire;
        public final Set<BlockPos> totems;

        public SummonPosition(CompoundNBT tag) {
            if (tag.func_74764_b("fire") || tag.func_74764_b("totems") || tag.func_74764_b("spawnPosition")) {
                this.fire = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("fire"));
                this.totems = new HashSet<BlockPos>(NbtHelper.toList((INBT)tag.func_74775_l("totems"), v -> NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)v))));
                this.spawnPosition = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("spawnPosition"));
            } else {
                this.totems = new HashSet<BlockPos>();
                this.spawnPosition = NBTUtil.func_186861_c((CompoundNBT)tag);
                this.fire = this.spawnPosition.func_177979_c(10);
            }
        }

        public SummonPosition(BlockPos fire, Set<BlockPos> totems) {
            this.fire = fire;
            this.spawnPosition = fire.func_177981_b(10);
            this.totems = totems;
        }

        public boolean isCancelled(World world) {
            return !this.check(this.fire, world);
        }

        private boolean check(BlockPos pos, World world) {
            return world.func_180495_p(pos).func_203425_a((Block)BlocksMCA.INFERNAL_FLAME.get());
        }

        public CompoundNBT toNbt() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("fire", (INBT)NBTUtil.func_186859_a((BlockPos)this.fire));
            tag.func_218657_a("totems", (INBT)NbtHelper.fromList(this.totems, NBTUtil::func_186859_a));
            tag.func_218657_a("spawnPosition", (INBT)NBTUtil.func_186859_a((BlockPos)this.spawnPosition));
            return tag;
        }
    }

    static class ActiveSummon {
        private int ticks;
        private SummonPosition position;

        ActiveSummon(long l) {
        }

        ActiveSummon(CompoundNBT nbt) {
            this.ticks = nbt.func_74762_e("ticks");
            this.position = new SummonPosition(nbt.func_74775_l("position"));
        }

        public void start(SummonPosition pos) {
            if (this.ticks <= 0) {
                this.position = pos;
                this.ticks = 100;
            }
        }

        public boolean tick(ServerWorld world) {
            if (this.ticks <= 0 || this.position == null) {
                return true;
            }
            if (this.position.isCancelled((World)world)) {
                this.position.totems.forEach(totem -> {
                    if (this.position.check(totem, (World)world)) {
                        world.func_175656_a(totem, Blocks.field_150480_ab.func_176223_P());
                    }
                });
                this.position = null;
                this.ticks = 0;
                return true;
            }
            if (--this.ticks % 20 == 0) {
                EntityType.field_200728_aG.func_220342_a(world, null, null, null, this.position.spawnPosition, SpawnReason.TRIGGERED, false, false);
            }
            if (this.ticks == 0) {
                GrimReaperEntity reaper = (GrimReaperEntity)((EntityType)EntitiesMCA.GRIM_REAPER.get()).func_220342_a(world, null, null, null, this.position.spawnPosition, SpawnReason.TRIGGERED, false, false);
                if (reaper != null) {
                    reaper.func_184185_a((SoundEvent)SoundsMCA.REAPER_SUMMON.get(), 1.0f, 1.0f);
                }
                return true;
            }
            return false;
        }

        public CompoundNBT write() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("ticks", this.ticks);
            nbt.func_218657_a("position", (INBT)this.position.toNbt());
            return nbt;
        }
    }
}

