/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server;

import forge.net.mca.Config;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.ai.relationship.EntityRelationship;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.network.s2c.OpenDestinyGuiRequest;
import forge.net.mca.network.s2c.ShowToastRequest;
import forge.net.mca.server.world.data.BabyTracker;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.util.compat.OptionalCompat;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;

public class ServerInteractionManager {
    private static final ServerInteractionManager INSTANCE = new ServerInteractionManager();
    private final Map<UUID, List<UUID>> proposals = new HashMap<UUID, List<UUID>>();
    private final Object2LongArrayMap<UUID> procreateMap = new Object2LongArrayMap();

    private ServerInteractionManager() {
    }

    public static ServerInteractionManager getInstance() {
        return INSTANCE;
    }

    public static void launchDestiny(ServerPlayerEntity player) {
        NetworkHandler.sendToPlayer(new OpenDestinyGuiRequest(player), player);
    }

    public void tick() {
        ArrayList removals = new ArrayList();
        this.procreateMap.keySet().stream().filter(k -> this.procreateMap.getLong(k) < System.currentTimeMillis()).forEach(removals::add);
        removals.forEach(arg_0 -> this.procreateMap.removeLong(arg_0));
    }

    public void onPlayerJoin(ServerPlayerEntity player) {
        PlayerSaveData playerData = PlayerSaveData.get(player);
        if (!playerData.isEntityDataSet()) {
            if (Config.getInstance().launchIntoDestiny) {
                ServerInteractionManager.launchDestiny(player);
                if (player.field_71134_c.func_73081_b() == GameType.SURVIVAL) {
                    player.func_71033_a(GameType.SPECTATOR);
                }
            } else if (Config.getInstance().allowDestinyCommandOnce) {
                NetworkHandler.sendToPlayer(new ShowToastRequest("server.destinyNotSet.title", "server.destinyNotSet.description"), player);
            } else if (Config.getInstance().allowFullPlayerEditor) {
                NetworkHandler.sendToPlayer(new ShowToastRequest("server.playerNotCustomized.title", "server.playerNotCustomized.description"), player);
            }
        }
        if (playerData.hasMail()) {
            PlayerSaveData.showMailNotification(player);
        }
    }

    private boolean hasProposalFrom(ServerPlayerEntity sender, ServerPlayerEntity receiver) {
        return this.getProposalsFor(receiver).contains(sender.func_110124_au());
    }

    private List<UUID> getProposalsFor(ServerPlayerEntity player) {
        return this.proposals.getOrDefault(player.func_110124_au(), new ArrayList());
    }

    private void removeProposalFor(ServerPlayerEntity target, ServerPlayerEntity proposer) {
        List<UUID> list = this.getProposalsFor(target);
        list.remove(proposer.func_110124_au());
        this.proposals.put(target.func_110124_au(), list);
    }

    public void listProposals(ServerPlayerEntity sender) {
        List<UUID> proposals = this.getProposalsFor(sender);
        if (proposals.size() == 0) {
            this.infoMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.noProposals"));
        } else {
            this.infoMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.proposals"));
        }
        proposals.forEach(uuid -> {
            PlayerEntity player = sender.field_70170_p.func_217371_b(uuid);
            if (player != null) {
                this.infoMessage((PlayerEntity)sender, (TextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new StringTextComponent(player.func_195047_I_())));
            }
        });
    }

    public void sendProposal(ServerPlayerEntity sender, ServerPlayerEntity receiver) {
        if (!Config.getInstance().allowPlayerMarriage) {
            this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("notify.playerMarriage.disabled"));
            return;
        }
        if (PlayerSaveData.get(sender).isMarried()) {
            this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.alreadyMarried"));
            return;
        }
        if (sender == receiver) {
            this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.proposedToYourself"));
            return;
        }
        if (this.hasProposalFrom(sender, receiver)) {
            this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.sentProposal", new Object[]{receiver.func_195047_I_()}));
        } else {
            this.successMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.proposalSent", new Object[]{receiver.func_195047_I_()}));
            this.infoMessage((PlayerEntity)receiver, (TextComponent)new TranslationTextComponent("server.proposedMarriage", new Object[]{sender.func_195047_I_()}));
            List<UUID> list = this.getProposalsFor(receiver);
            list.add(sender.func_110124_au());
            this.proposals.put(receiver.func_110124_au(), list);
        }
    }

    public void rejectProposal(ServerPlayerEntity sender, ServerPlayerEntity receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.noProposal", new Object[]{receiver.func_145748_c_()}));
        } else {
            this.successMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.proposalRejectionSent"));
            this.failMessage((PlayerEntity)receiver, (TextComponent)new TranslationTextComponent("server.proposalRejected", new Object[]{sender.func_195047_I_()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void acceptProposal(ServerPlayerEntity sender, ServerPlayerEntity receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.noProposal", new Object[]{receiver.func_145748_c_()}));
        } else {
            this.successMessage((PlayerEntity)receiver, (TextComponent)new TranslationTextComponent("server.proposalAccepted", new Object[]{sender.func_145748_c_()}));
            PlayerSaveData.get(sender).marry((Entity)receiver);
            PlayerSaveData.get(receiver).marry((Entity)sender);
            this.successMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.married", new Object[]{receiver.func_145748_c_()}));
            this.successMessage((PlayerEntity)receiver, (TextComponent)new TranslationTextComponent("server.married", new Object[]{sender.func_145748_c_()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void endMarriage(ServerPlayerEntity sender) {
        EntityRelationship.of((Entity)sender).ifPresent(senderData -> {
            if (!senderData.isMarried()) {
                this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.endMarriageNotMarried"));
                return;
            }
            if (senderData.getRelationshipState() != RelationshipState.MARRIED_TO_PLAYER) {
                this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.marriedToVillager"));
                return;
            }
            senderData.getPartnerName().ifPresent(name -> this.successMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.endMarriage", new Object[]{name.getString()})));
            senderData.getPartner().ifPresent(spouse -> {
                if (spouse instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)spouse;
                    this.failMessage(player, (TextComponent)new TranslationTextComponent("server.marriageEnded", new Object[]{sender.func_195047_I_()}));
                }
            });
            senderData.endRelationShip(RelationshipState.SINGLE);
            senderData.getPartnerUUID().map(id -> PlayerSaveData.get(sender)).ifPresent(r -> r.endRelationShip(RelationshipState.SINGLE));
        });
    }

    public void procreate(ServerPlayerEntity sender) {
        PlayerSaveData senderData = PlayerSaveData.get(sender);
        if (!senderData.isMarried()) {
            this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.notMarried"));
            return;
        }
        if (senderData.getRelationshipState() != RelationshipState.MARRIED_TO_PLAYER) {
            this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.marriedToVillager"));
            return;
        }
        BabyTracker tracker = BabyTracker.get(sender.func_71121_q());
        BabyTracker.Pairing pairing = tracker.getPairing(sender.func_110124_au(), senderData.getPartnerUUID().orElse(null));
        if (tracker.hasActiveBaby(sender.func_110124_au(), senderData.getPartnerUUID().orElse(null))) {
            if (((BabyTracker.Placement)((Object)pairing.locateBaby((PlayerEntity)sender).getRight())).wasFound()) {
                this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.babyPresent"));
            } else {
                this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.babyLost"));
                pairing.reconstructBaby(sender);
            }
            return;
        }
        OptionalCompat.ifPresentOrElse(senderData.getPartner().filter(e -> e instanceof PlayerEntity).map(PlayerEntity.class::cast), spouse -> {
            if (!this.procreateMap.containsKey((Object)spouse.func_110124_au())) {
                this.procreateMap.put((Object)sender.func_110124_au(), System.currentTimeMillis() + 10000L);
                this.infoMessage((PlayerEntity)spouse, (TextComponent)new TranslationTextComponent("server.procreationRequest", new Object[]{sender.func_195047_I_()}));
            } else {
                this.successMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.procreationSuccessful"));
                this.successMessage((PlayerEntity)spouse, (TextComponent)new TranslationTextComponent("server.procreationSuccessful"));
                pairing.addChild(s -> {
                    s.setGender(Gender.getRandom());
                    s.setOwner((Entity)sender);
                    spouse.func_191521_c(s.createItem());
                });
            }
        }, () -> this.failMessage((PlayerEntity)sender, (TextComponent)new TranslationTextComponent("server.spouseNotPresent")));
    }

    private void successMessage(PlayerEntity player, TextComponent message) {
        player.func_145747_a((ITextComponent)message.func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
    }

    private void failMessage(PlayerEntity player, TextComponent message) {
        player.func_145747_a((ITextComponent)message.func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
    }

    private void infoMessage(PlayerEntity player, TextComponent message) {
        player.func_145747_a((ITextComponent)message.func_240699_a_(TextFormatting.YELLOW), Util.field_240973_b_);
    }
}

