/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server;

import forge.net.mca.Config;
import forge.net.mca.ducks.IVillagerEntity;
import forge.net.mca.entity.VillagerFactory;
import forge.net.mca.entity.ZombieVillagerEntityMCA;
import forge.net.mca.entity.ZombieVillagerFactory;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.server.world.data.Nationality;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final List<VillagerEntity> villagerSpawnQueue = new LinkedList<VillagerEntity>();
    private final List<ZombieVillagerEntity> zombieVillagerSpawnQueue = new LinkedList<ZombieVillagerEntity>();

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    public void tick() {
        VillagerEntity e;
        if (!this.villagerSpawnQueue.isEmpty()) {
            e = this.villagerSpawnQueue.remove(0);
            if (e.field_70170_p.func_195588_v(e.func_233580_cy_())) {
                e.func_70106_y();
                VillagerFactory.newVillager(e.field_70170_p).withName(e.func_145818_k_() ? e.func_200200_C_().getString() : null).withGender(Gender.getRandom()).withAge(e.func_70874_b()).withPosition((Entity)e).withType(e.func_213700_eh().func_221129_a()).withProfession(e.func_213700_eh().func_221130_b(), e.func_213700_eh().func_221132_c(), e.func_213706_dY()).spawn(((IVillagerEntity)e).getSpawnReason());
            } else {
                this.villagerSpawnQueue.add(e);
            }
        }
        if (!this.zombieVillagerSpawnQueue.isEmpty()) {
            e = this.zombieVillagerSpawnQueue.remove(0);
            if (e.field_70170_p.func_195588_v(e.func_233580_cy_())) {
                e.func_70106_y();
                ZombieVillagerEntityMCA z = ZombieVillagerFactory.newVillager(e.field_70170_p).withName(e.func_145818_k_() ? e.func_200200_C_().getString() : null).withGender(Gender.getRandom()).withPosition((Entity)e).withType(e.func_213700_eh().func_221129_a()).withProfession(e.func_213700_eh().func_221130_b(), e.func_213700_eh().func_221132_c()).spawn(((IVillagerEntity)e).getSpawnReason());
                if (e.func_104002_bU()) {
                    z.func_110163_bv();
                }
            } else {
                this.zombieVillagerSpawnQueue.add((ZombieVillagerEntity)e);
            }
        }
    }

    public static boolean shouldGetConverted(Entity entity) {
        if (Config.getInstance().percentageOfVanillaVillages <= 0) {
            return true;
        }
        int i = Nationality.get((ServerWorld)entity.func_130014_f_()).getRegionId(entity.func_233580_cy_());
        return Math.floorMod(i, 100) >= Config.getInstance().percentageOfVanillaVillages;
    }

    public boolean addVillager(Entity entity) {
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason(((IVillagerEntity)entity).getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().villagerDimensionBlacklist.contains(entity.func_130014_f_().func_234923_W_().func_240901_a_().toString())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && (entity.getClass().equals(VillagerEntity.class) || Config.getInstance().moddedVillagerWhitelist.contains(Registry.field_212629_r.func_177774_c((Object)entity.func_200600_R()).toString()) && entity instanceof VillagerEntity) && SpawnQueue.shouldGetConverted(entity) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((VillagerEntity)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && (entity.getClass().equals(ZombieVillagerEntity.class) || Config.getInstance().moddedZombieVillagerWhitelist.contains(Registry.field_212629_r.func_177774_c((Object)entity.func_200600_R()).toString()) && entity instanceof ZombieVillagerEntity) && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((ZombieVillagerEntity)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(SpawnReason reason) {
        return Config.getInstance().allowedSpawnReasons.contains(reason.name().toLowerCase(Locale.ROOT));
    }

    public void convert(VillagerEntity villager) {
        this.villagerSpawnQueue.add(villager);
    }
}

